/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class NativeTrustedRootsInternalUtils {
    private static final String _OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    public static final boolean isWindows = _OS_NAME.startsWith("windows");
    public static final boolean isMac = _OS_NAME.startsWith("mac");
    public static final boolean isLinux = _OS_NAME.startsWith("linux");

    public static String renderExceptionMessage(@NotNull String message, @NotNull Throwable exception) {
        StringWriter throwableText = new StringWriter();
        exception.printStackTrace(new PrintWriter(throwableText));
        return message + ": " + exception.getMessage() + "\n" + String.valueOf(throwableText);
    }

    public static String sha256hex(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(bytes);
            return NativeTrustedRootsInternalUtils.toHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sha1hex(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] hash = digest.digest(bytes);
            return NativeTrustedRootsInternalUtils.toHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static X509Certificate parseCertificate(byte[] bytes) {
        try {
            return NativeTrustedRootsInternalUtils.parseCertificate(bytes, CertificateFactory.getInstance("X.509"));
        }
        catch (Throwable e) {
            CertificateFactory bcProvider;
            Logger logger = Logger.getLogger(NativeTrustedRootsInternalUtils.class.getName());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to parse certificate with a standard X509 parser, falling back to BouncyCastle", e));
            }
            try {
                bcProvider = CertificateFactory.getInstance("X.509", (Provider)BouncyCastleLazyProvider.INSTANCE);
            }
            catch (CertificateException ex) {
                throw new RuntimeException(ex);
            }
            return NativeTrustedRootsInternalUtils.parseCertificate(bytes, bcProvider);
        }
    }

    static X509Certificate parseCertificate(byte[] bytes, CertificateFactory cf) {
        try {
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bytes));
            certificate.getPublicKey();
            return certificate;
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BouncyCastleLazyProvider {
        public static final BouncyCastleProvider INSTANCE = new BouncyCastleProvider();

        private BouncyCastleLazyProvider() {
        }
    }
}

