/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.dependency.fest_reflect.field;

import org.assertj.swing.dependency.fest_reflect.field.StaticFieldType;
import org.assertj.swing.dependency.fest_reflect.field.StaticFieldTypeRef;
import org.assertj.swing.dependency.fest_reflect.reference.TypeRef;
import org.assertj.swing.dependency.fest_util.Strings;

public final class StaticFieldName {
    private final String name;

    public static StaticFieldName beginStaticFieldAccess(String name) {
        StaticFieldName.validateIsNotNullOrEmpty(name);
        return new StaticFieldName(name);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the static field to access should not be null");
        }
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("The name of the static field to access should not be empty");
        }
    }

    private StaticFieldName(String name) {
        this.name = name;
    }

    public <T> StaticFieldType<T> ofType(Class<T> type) {
        return StaticFieldType.newFieldType(this.name, type);
    }

    public <T> StaticFieldTypeRef<T> ofType(TypeRef<T> type) {
        return StaticFieldTypeRef.newFieldTypeRef(this.name, type);
    }
}

