/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html.paths;

import java.io.File;
import jetbrains.coverage.report.impl.html.SortOption;
import jetbrains.coverage.report.impl.html.paths.ClassesDirGenerator;
import jetbrains.coverage.report.impl.html.paths.NamesGenerator;
import jetbrains.coverage.report.impl.html.paths.NamespaceInfo;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespacesDirGenerator
extends NamesGenerator<NamespaceInfo, ClassesDirGenerator> {
    private final File myBase;

    public NamespacesDirGenerator(@NotNull File base) {
        this.myBase = base;
    }

    @Override
    @NotNull
    protected ClassesDirGenerator createV(long id) {
        return new ClassesDirGenerator(new File(this.myBase, "ns-" + Long.toHexString(id)));
    }

    @Override
    @NotNull
    protected Object makeKey(@NotNull NamespaceInfo namespaceInfo) {
        String namespace = namespaceInfo.getNamespace();
        return namespace == null ? ")(*&^%$#@!___EMPTY_NAMESPACE_NAME__)(*&^%$#@!" : namespace;
    }

    @NotNull
    public File getBase() {
        return this.myBase;
    }

    @NotNull
    public File getNamespaceIndexPath(@NotNull SortOption order) {
        return new File(this.myBase, order.getIndexFileName());
    }
}

