/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources;

import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.SkiaImageAsset_skikoKt;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.resources.SvgElement;
import org.jetbrains.compose.resources.SvgPainter;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.SamplingMode;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.svg.SVGDOM;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0002H\u0000\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"toImageBitmap", "Landroidx/compose/ui/graphics/ImageBitmap;", "", "resourceDensity", "", "targetDensity", "toSvgElement", "Lorg/jetbrains/compose/resources/SvgElement;", "toSvgPainter", "Landroidx/compose/ui/graphics/painter/Painter;", "density", "Landroidx/compose/ui/unit/Density;", "library"})
@SourceDebugExtension(value={"SMAP\nImageResources.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageResources.skiko.kt\norg/jetbrains/compose/resources/ImageResources_skikoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class ImageResources_skikoKt {
    @NotNull
    public static final ImageBitmap toImageBitmap(@NotNull byte[] $this$toImageBitmap, int resourceDensity, int targetDensity) {
        Intrinsics.checkNotNullParameter((Object)$this$toImageBitmap, (String)"<this>");
        Image image = Image.Companion.makeFromEncoded($this$toImageBitmap);
        Image targetImage = null;
        if (resourceDensity > targetDensity) {
            Paint paint;
            float scale = (float)targetDensity / (float)resourceDensity;
            float targetH = (float)image.getHeight() * scale;
            float targetW = (float)image.getWidth() * scale;
            Rect srcRect = Rect.Companion.makeWH((float)image.getWidth(), (float)image.getHeight());
            Rect dstRect = Rect.Companion.makeWH(targetW, targetH);
            Surface $this$toImageBitmap_u24lambda_u241 = Surface.Companion.makeRasterN32Premul((int)targetW, (int)targetH);
            boolean bl = false;
            Paint $this$toImageBitmap_u24lambda_u241_u24lambda_u240 = paint = new Paint();
            boolean bl2 = false;
            $this$toImageBitmap_u24lambda_u241_u24lambda_u240.setAntiAlias(true);
            Paint paint2 = paint;
            $this$toImageBitmap_u24lambda_u241.getCanvas().drawImageRect(image, srcRect, dstRect, SamplingMode.Companion.getLINEAR(), paint2, true);
            targetImage = $this$toImageBitmap_u24lambda_u241.makeImageSnapshot();
        } else {
            targetImage = image;
        }
        return SkiaImageAsset_skikoKt.toComposeImageBitmap((Image)targetImage);
    }

    @NotNull
    public static final SvgElement toSvgElement(@NotNull byte[] $this$toSvgElement) {
        Intrinsics.checkNotNullParameter((Object)$this$toSvgElement, (String)"<this>");
        return new SvgElement(new SVGDOM(Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])$this$toSvgElement, (int)0, (int)0, (int)6, null)));
    }

    @NotNull
    public static final Painter toSvgPainter(@NotNull SvgElement $this$toSvgPainter, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)$this$toSvgPainter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return new SvgPainter($this$toSvgPainter.getSvgdom(), density);
    }
}

