from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

ESPERANTO_LANG_MODEL = {
    27: {  # 'A'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.LIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        25: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        45: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.POSITIVE,  # 'ŭ'
    },
    36: {  # 'B'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.POSITIVE,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    35: {  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.LIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    38: {  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    31: {  # 'E'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.LIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        25: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.LIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.POSITIVE,  # 'ŭ'
    },
    42: {  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    43: {  # 'G'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    44: {  # 'H'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    40: {  # 'I'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.LIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.POSITIVE,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        25: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        26: SequenceLikelihood.POSITIVE,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    47: {  # 'J'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    34: {  # 'K'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    25: {  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    29: {  # 'M'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    39: {  # 'N'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.LIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    49: {  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.LIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    30: {  # 'P'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    61: {  # 'Q'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.NEGATIVE,  # 'ŭ'
    },
    37: {  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    26: {  # 'S'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.POSITIVE,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        45: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    32: {  # 'T'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    50: {  # 'U'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        26: SequenceLikelihood.POSITIVE,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    46: {  # 'V'
        27: SequenceLikelihood.LIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    51: {  # 'W'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    59: {  # 'X'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    55: {  # 'Y'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    56: {  # 'Z'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    1: {  # 'a'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        18: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        17: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.POSITIVE,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.POSITIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.POSITIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.LIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.POSITIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.POSITIVE,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.POSITIVE,  # 'ŭ'
    },
    20: {  # 'b'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    18: {  # 'c'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    11: {  # 'd'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        45: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    2: {  # 'e'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        18: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        17: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.POSITIVE,  # 'w'
        52: SequenceLikelihood.POSITIVE,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.POSITIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.POSITIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.LIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.LIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.LIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.POSITIVE,  # 'ŭ'
    },
    19: {  # 'f'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        17: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    17: {  # 'g'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    21: {  # 'h'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    4: {  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        18: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        17: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.POSITIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.POSITIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.LIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.LIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    12: {  # 'j'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    10: {  # 'k'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    8: {  # 'l'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        17: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.LIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.LIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.LIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    14: {  # 'm'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.POSITIVE,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    5: {  # 'n'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        18: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        17: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.POSITIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.POSITIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.LIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    3: {  # 'o'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.LIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        18: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        17: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.POSITIVE,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.POSITIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.POSITIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.LIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.POSITIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    15: {  # 'p'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    58: {  # 'q'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.NEGATIVE,  # 'ŭ'
    },
    6: {  # 'r'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        18: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        17: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.POSITIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.POSITIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.LIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.POSITIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    9: {  # 's'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        17: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    7: {  # 't'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.LIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    13: {  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        18: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        17: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.LIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.POSITIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.POSITIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    16: {  # 'v'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    45: {  # 'w'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.POSITIVE,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    52: {  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    33: {  # 'y'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.LIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.UNLIKELY,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    22: {  # 'z'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    53: {  # 'Ĉ'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.NEGATIVE,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        58: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        45: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    28: {  # 'ĉ'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        38: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        43: SequenceLikelihood.NEGATIVE,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.NEGATIVE,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        46: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        55: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.UNLIKELY,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    54: {  # 'Ĝ'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        58: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    23: {  # 'ĝ'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        38: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        43: SequenceLikelihood.NEGATIVE,  # 'G'
        44: SequenceLikelihood.NEGATIVE,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        34: SequenceLikelihood.NEGATIVE,  # 'K'
        25: SequenceLikelihood.NEGATIVE,  # 'L'
        29: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.NEGATIVE,  # 'R'
        26: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        46: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        55: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    63: {  # 'Ĥ'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.NEGATIVE,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        55: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        18: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.NEGATIVE,  # 'f'
        17: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        12: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        58: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    60: {  # 'ĥ'
        27: SequenceLikelihood.NEGATIVE,  # 'A'
        36: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        38: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.NEGATIVE,  # 'G'
        44: SequenceLikelihood.NEGATIVE,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.NEGATIVE,  # 'L'
        29: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.NEGATIVE,  # 'R'
        26: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        55: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    62: {  # 'Ĵ'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.NEGATIVE,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.NEGATIVE,  # 'R'
        26: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        55: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        18: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.NEGATIVE,  # 'f'
        17: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        58: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    48: {  # 'ĵ'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        38: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        43: SequenceLikelihood.NEGATIVE,  # 'G'
        44: SequenceLikelihood.NEGATIVE,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        34: SequenceLikelihood.NEGATIVE,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.NEGATIVE,  # 'R'
        26: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        46: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        55: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    57: {  # 'Ŝ'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.NEGATIVE,  # 'f'
        17: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    41: {  # 'ŝ'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        38: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.NEGATIVE,  # 'G'
        44: SequenceLikelihood.NEGATIVE,  # 'H'
        40: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        34: SequenceLikelihood.NEGATIVE,  # 'K'
        25: SequenceLikelihood.NEGATIVE,  # 'L'
        29: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        55: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        17: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.NEGATIVE,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    64: {  # 'Ŭ'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        59: SequenceLikelihood.UNLIKELY,  # 'X'
        55: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        18: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.NEGATIVE,  # 'f'
        17: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        58: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        45: SequenceLikelihood.NEGATIVE,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        53: SequenceLikelihood.UNLIKELY,  # 'Ĉ'
        28: SequenceLikelihood.NEGATIVE,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.NEGATIVE,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.NEGATIVE,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.NEGATIVE,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
    24: {  # 'ŭ'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        36: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        44: SequenceLikelihood.UNLIKELY,  # 'H'
        40: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        37: SequenceLikelihood.UNLIKELY,  # 'R'
        26: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        46: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        59: SequenceLikelihood.NEGATIVE,  # 'X'
        55: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        18: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        17: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        12: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        58: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        45: SequenceLikelihood.UNLIKELY,  # 'w'
        52: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        53: SequenceLikelihood.NEGATIVE,  # 'Ĉ'
        28: SequenceLikelihood.UNLIKELY,  # 'ĉ'
        54: SequenceLikelihood.NEGATIVE,  # 'Ĝ'
        23: SequenceLikelihood.UNLIKELY,  # 'ĝ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ĥ'
        60: SequenceLikelihood.UNLIKELY,  # 'ĥ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ĵ'
        48: SequenceLikelihood.UNLIKELY,  # 'ĵ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ŝ'
        41: SequenceLikelihood.UNLIKELY,  # 'ŝ'
        64: SequenceLikelihood.NEGATIVE,  # 'Ŭ'
        24: SequenceLikelihood.UNLIKELY,  # 'ŭ'
    },
}

# Character Mapping Table(s):
ISO_8859_3_ESPERANTO_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 27,  # 'A'
    66: 36,  # 'B'
    67: 35,  # 'C'
    68: 38,  # 'D'
    69: 31,  # 'E'
    70: 42,  # 'F'
    71: 43,  # 'G'
    72: 44,  # 'H'
    73: 40,  # 'I'
    74: 47,  # 'J'
    75: 34,  # 'K'
    76: 25,  # 'L'
    77: 29,  # 'M'
    78: 39,  # 'N'
    79: 49,  # 'O'
    80: 30,  # 'P'
    81: 61,  # 'Q'
    82: 37,  # 'R'
    83: 26,  # 'S'
    84: 32,  # 'T'
    85: 50,  # 'U'
    86: 46,  # 'V'
    87: 51,  # 'W'
    88: 59,  # 'X'
    89: 55,  # 'Y'
    90: 56,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 20,  # 'b'
    99: 18,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 19,  # 'f'
    103: 17,  # 'g'
    104: 21,  # 'h'
    105: 4,  # 'i'
    106: 12,  # 'j'
    107: 10,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 5,  # 'n'
    111: 3,  # 'o'
    112: 15,  # 'p'
    113: 58,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 7,  # 't'
    117: 13,  # 'u'
    118: 16,  # 'v'
    119: 45,  # 'w'
    120: 52,  # 'x'
    121: 33,  # 'y'
    122: 22,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ħ'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.UNDEFINED,  # None
    166: 63,  # 'Ĥ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 0,  # 'İ'
    170: 0,  # 'Ş'
    171: 0,  # 'Ğ'
    172: 62,  # 'Ĵ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.UNDEFINED,  # None
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 0,  # 'ħ'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: 60,  # 'ĥ'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 0,  # 'ı'
    186: 0,  # 'ş'
    187: 0,  # 'ğ'
    188: 48,  # 'ĵ'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.UNDEFINED,  # None
    191: 0,  # 'ż'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: CharacterCategory.UNDEFINED,  # None
    196: 0,  # 'Ä'
    197: 0,  # 'Ċ'
    198: 53,  # 'Ĉ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: CharacterCategory.UNDEFINED,  # None
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ġ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 54,  # 'Ĝ'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 64,  # 'Ŭ'
    222: 57,  # 'Ŝ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: CharacterCategory.UNDEFINED,  # None
    228: 0,  # 'ä'
    229: 0,  # 'ċ'
    230: 28,  # 'ĉ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: CharacterCategory.UNDEFINED,  # None
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ġ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 23,  # 'ĝ'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 24,  # 'ŭ'
    254: 41,  # 'ŝ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_3_ESPERANTO_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-3",
    language="Esperanto",
    char_to_order_map=ISO_8859_3_ESPERANTO_CHAR_TO_ORDER,
    language_model=ESPERANTO_LANG_MODEL,
    typical_positive_ratio=0.9794321870026351,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĈĉĜĝĤĥĴĵŜŝŬŭ",
)
