# frozen_string_literal: true

require_relative '../lib/gettext-setup'

GettextSetup.initialize(File.join(File.dirname(__FILE__), 'fixtures', 'locales'))

def cmd_present?(cmd)
  # Try to call out to msgcmp, if it doesn't error, we have the tool
  `#{cmd} --version`
  true
rescue IOError
  false
end

def msgcmp_present?
  cmd_present?('msgcmp')
end

def msginit_present?
  cmd_present?('msginit')
end

def msgmerge_present?
  cmd_present?('msgmerge')
end
