﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/organizations/Organizations_EXPORTS.h>
#include <aws/organizations/model/Child.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Organizations {
namespace Model {
class ListChildrenResult {
 public:
  AWS_ORGANIZATIONS_API ListChildrenResult() = default;
  AWS_ORGANIZATIONS_API ListChildrenResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ORGANIZATIONS_API ListChildrenResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of children of the specified parent container.</p>
   */
  inline const Aws::Vector<Child>& GetChildren() const { return m_children; }
  template <typename ChildrenT = Aws::Vector<Child>>
  void SetChildren(ChildrenT&& value) {
    m_childrenHasBeenSet = true;
    m_children = std::forward<ChildrenT>(value);
  }
  template <typename ChildrenT = Aws::Vector<Child>>
  ListChildrenResult& WithChildren(ChildrenT&& value) {
    SetChildren(std::forward<ChildrenT>(value));
    return *this;
  }
  template <typename ChildrenT = Child>
  ListChildrenResult& AddChildren(ChildrenT&& value) {
    m_childrenHasBeenSet = true;
    m_children.emplace_back(std::forward<ChildrenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If present, indicates that more output is available than is included in the
   * current response. Use this value in the <code>NextToken</code> request parameter
   * in a subsequent call to the operation to get the next part of the output. You
   * should repeat this until the <code>NextToken</code> response element comes back
   * as <code>null</code>.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListChildrenResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListChildrenResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Child> m_children;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_childrenHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Organizations
}  // namespace Aws
