"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.downloadPublicKey = exports.loadPublicKey = exports.loadPrivateKey = void 0;
const node_fetch_1 = __importDefault(require("node-fetch"));
const fs = __importStar(require("node:fs"));
const download_1 = require("./download");
const endpoints_1 = require("./endpoints");
const loadPrivateKey = (keyPath) => {
    return fs.promises.readFile(keyPath, "utf8");
};
exports.loadPrivateKey = loadPrivateKey;
const loadPublicKey = (keyPath) => {
    return fs.promises.readFile(keyPath, "utf8");
};
exports.loadPublicKey = loadPublicKey;
const ensureValidPublicKeyUrl = async (url) => {
    const publicKeyResponse = await (0, node_fetch_1.default)(url.toString());
    if (!publicKeyResponse.ok) {
        throw new Error("Default public key URL is not valid. Aborting signature verification.");
    }
    else {
        return url;
    }
};
const getPulicKeyUrl = async (extension) => {
    const registryUrl = new URL((0, endpoints_1.getMarketplaceEndpoint)());
    const defaultPublicKeyUrl = registryUrl.toString() + `file/public.pem`;
    const registryApiEndpoint = registryUrl.toString() + `api/${extension.id.split(".").join("/")}/${extension.version}`;
    const extensionApiResponse = await (0, node_fetch_1.default)(registryApiEndpoint.toString());
    if (!extensionApiResponse.ok) {
        console.warn("Failed to fetch extension data from registry API. Trying to use the default public key:");
        console.warn(defaultPublicKeyUrl.toString());
        return ensureValidPublicKeyUrl(defaultPublicKeyUrl);
    }
    const extensionApiData = await extensionApiResponse.json();
    if (!extensionApiData?.files?.signature) {
        console.error("Registry did not provide a public key file. Trying to use the default public key:");
        console.warn(defaultPublicKeyUrl.toString());
        return ensureValidPublicKeyUrl(defaultPublicKeyUrl);
    }
    return extensionApiData.files.publicKey;
};
const downloadPublicKey = async (extension) => {
    const urlOfPublicKey = await getPulicKeyUrl(extension);
    const downloadLocation = await (0, download_1.download)(urlOfPublicKey, { filename: "public.pem" });
    return downloadLocation;
};
exports.downloadPublicKey = downloadPublicKey;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/591199df409fbf59b4b52d5ad4ee0470152a9b31/node_modules/node-ovsx-sign/lib/utils/keys.js.map