/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.firebirdsql.ds.FBPooledConnection;
import org.firebirdsql.ds.PooledConnectionHandler;
import org.firebirdsql.ds.XAConnectionHandler;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jaybird.xca.FBManagedConnection;
import org.firebirdsql.jdbc.FBConnection;

public final class FBXAConnection
extends FBPooledConnection
implements XAConnection {
    private final WeakReference<FBManagedConnection> mc;

    FBXAConnection(FBConnection connection) {
        super(connection);
        this.mc = new WeakReference<FBManagedConnection>(connection.getManagedConnection());
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this.getManagedConnection().getXAResource();
    }

    @Override
    void resetConnection(Connection connection) throws SQLException {
        if (!this.inDistributedTransaction()) {
            super.resetConnection(connection);
        }
    }

    @Override
    PooledConnectionHandler createConnectionHandler(Connection connection) {
        return new XAConnectionHandler(connection, this);
    }

    boolean inDistributedTransaction() throws SQLException {
        return this.getManagedConnection().inDistributedTransaction();
    }

    private FBManagedConnection getManagedConnection() throws SQLException {
        FBManagedConnection managedConnection = (FBManagedConnection)this.mc.get();
        if (managedConnection == null) {
            throw FbExceptionBuilder.toNonTransientConnectionException(337248335);
        }
        return managedConnection;
    }
}

