/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.LazyPyCArrayTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArrayTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArrayTypeBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCArrayType})
public final class PyCArrayTypeBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = PyCArrayTypeBuiltinsSlotsGen.SLOTS;
    protected static final TruffleString T__LENGTH_ = PythonUtils.tsLiteral("_length_");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PyCArrayTypeBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @ImportStatic(value={PyCPointerTypeBuiltins.class, PyCArrayTypeBuiltins.class, SpecialMethodNames.class})
    @GenerateNodeFactory
    protected static abstract class PyCArrayTypeNewNode
    extends PythonBuiltinNode {
        protected PyCArrayTypeNewNode() {
        }

        @Specialization
        static Object PyCArrayType_new(VirtualFrame frame, Object type, Object[] args, PKeyword[] kwds, @Bind Node inliningTarget, @Cached PyObjectLookupAttr lookupAttrType, @Cached PyObjectLookupAttr lookupAttrLength, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profile, @Cached PyNumberAsSizeNode asSizeNode, @Cached TypeBuiltins.TypeNode typeNew, @Cached GetDictIfExistsNode getDict, @Cached SetDictNode setDict, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            int itemsize;
            int length;
            Object result = typeNew.execute(frame, type, args[0], args[1], args[2], kwds);
            Object length_attr = lookupAttrLength.execute((Frame)frame, inliningTarget, result, T__LENGTH_);
            if (length_attr == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.CLASS_MUST_DEFINE_A_LENGTH_ATTRIBUTE);
            }
            try {
                length = asSizeNode.executeExact((Frame)frame, inliningTarget, length_attr);
            }
            catch (PException e) {
                if (e.expectTypeOrOverflowError(inliningTarget, profile)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.THE_LENGTH_ATTRIBUTE_IS_TOO_LARGE);
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.THE_LENGTH_ATTRIBUTE_MUST_BE_AN_INTEGER);
            }
            if (length < 0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.THE_LENGTH_ATTRIBUTE_MUST_NOT_BE_NEGATIVE);
            }
            Object type_attr = lookupAttrType.execute((Frame)frame, inliningTarget, result, PyCPointerTypeBuiltins.T__TYPE_);
            if (type_attr == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.CLASS_MUST_DEFINE_A_TYPE_ATTRIBUTE);
            }
            StgDictObject stgdict = PFactory.createStgDictObject(language);
            StgDictObject itemdict = pyTypeStgDictNode.execute(inliningTarget, type_attr);
            if (itemdict == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TYPE_MUST_HAVE_STORAGE_INFO);
            }
            assert (itemdict.format != null);
            stgdict.format = itemdict.format;
            stgdict.ndim = itemdict.ndim + 1;
            stgdict.shape = new int[stgdict.ndim];
            stgdict.shape[0] = length;
            if (stgdict.ndim > 1) {
                int i = 0;
                int j = 1;
                while (i < stgdict.ndim - 1) {
                    stgdict.shape[j] = itemdict.shape[i];
                    ++i;
                    ++j;
                }
            }
            if ((itemsize = itemdict.size) != 0 && length > Integer.MAX_VALUE / itemsize) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.ARRAY_TOO_LARGE);
            }
            int itemalign = itemdict.align;
            if ((itemdict.flags & 0x300) != 0) {
                stgdict.flags |= 0x200;
            }
            stgdict.size = itemsize * length;
            stgdict.align = itemalign;
            stgdict.length = length;
            stgdict.proto = type_attr;
            stgdict.paramfunc = 1;
            stgdict.ffi_type_pointer = FFIType.ffi_type_pointer;
            PDict resDict = getDict.execute(result);
            if (resDict == null) {
                resDict = PFactory.createDictFixedStorage(language, (PythonObject)result);
            }
            addAllToOtherNode.execute((Frame)frame, inliningTarget, resDict.getDictStorage(), stgdict);
            setDict.execute(inliningTarget, (PythonObject)result, stgdict);
            if (itemdict.getfunc == FFIType.FieldDesc.c.getfunc) {
                LazyPyCArrayTypeBuiltins.createCharArrayGetSet(PythonLanguage.get(inliningTarget), result);
            } else if (itemdict.getfunc == FFIType.FieldDesc.u.getfunc) {
                LazyPyCArrayTypeBuiltins.createWCharArrayGetSet(PythonLanguage.get(inliningTarget), result);
            }
            return result;
        }
    }
}

