/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={PGuards.class})
@GenerateUncached
@GenerateInline(value=false)
public abstract class BaseExceptionAttrNode
extends Node {
    public final Object get(PBaseException self, int index, StorageFactory factory) {
        return this.execute(self, PNone.NO_VALUE, index, factory);
    }

    public final int getInt(PBaseException self, int index, StorageFactory factory) {
        Object val = this.execute(self, PNone.NO_VALUE, index, factory);
        assert (val instanceof Integer) : "expected PBaseException attribute to be an integer";
        return (Integer)val;
    }

    public final Object set(PBaseException self, Object value, int index, StorageFactory factory) {
        return this.execute(self, value, index, factory);
    }

    public abstract Object execute(PBaseException var1, Object var2, int var3, StorageFactory var4);

    protected static boolean withAttributes(PBaseException self) {
        return self.getExceptionAttributes() != null;
    }

    @Specialization(guards={"isNoValue(none)", "withAttributes(self)"})
    public Object getAttrWithStorage(PBaseException self, PNone none, int index, StorageFactory factory) {
        Object[] attributes = self.getExceptionAttributes();
        assert (index >= 0 && index < attributes.length) : "PBaseException attribute index is out of range";
        Object value = attributes[index];
        return value != null ? value : PNone.NONE;
    }

    @Specialization(guards={"isNoValue(none)", "!withAttributes(self)"})
    public Object getAttrNoStorage(PBaseException self, PNone none, int index, StorageFactory factory, @Cached.Shared @Cached EnsureAttrStorageNode ensureAttrStorageNode) {
        Object[] attributes = ensureAttrStorageNode.execute(self, factory);
        assert (attributes != null) : "PBaseException attributes field is null";
        return this.getAttrWithStorage(self, none, index, factory);
    }

    @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)", "withAttributes(self)"})
    public Object setAttrWithStorage(PBaseException self, Object value, int index, StorageFactory factory) {
        Object[] attributes = self.getExceptionAttributes();
        assert (index >= 0 && index < attributes.length) : "PBaseException attribute index is out of range";
        attributes[index] = value;
        return PNone.NONE;
    }

    @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)", "!withAttributes(self)"})
    public Object setAttrNoStorage(PBaseException self, Object value, int index, StorageFactory factory, @Cached.Shared @Cached EnsureAttrStorageNode ensureAttrStorageNode) {
        Object[] attributes = ensureAttrStorageNode.execute(self, factory);
        assert (attributes != null) : "PBaseException attributes field is null";
        return this.setAttrWithStorage(self, value, index, factory);
    }

    @Specialization(guards={"!isNoValue(value)", "isDeleteMarker(value)", "withAttributes(self)"})
    public Object delAttrWithStorage(PBaseException self, Object value, int index, StorageFactory factory) {
        Object[] attributes = self.getExceptionAttributes();
        assert (index >= 0 && index < attributes.length) : "PBaseException attribute index is out of range";
        attributes[index] = null;
        return PNone.NONE;
    }

    @Specialization(guards={"!isNoValue(value)", "isDeleteMarker(value)", "!withAttributes(self)"})
    public Object delAttrNoStorage(PBaseException self, Object value, int index, StorageFactory factory, @Cached.Shared @Cached EnsureAttrStorageNode ensureAttrStorageNode) {
        Object[] attributes = ensureAttrStorageNode.execute(self, factory);
        assert (attributes != null) : "PBaseException attributes field is null";
        return this.delAttrWithStorage(self, value, index, factory);
    }

    public static interface StorageFactory {
        public Object[] create(Object[] var1);

        default public Object[] create() {
            return this.create(null);
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class EnsureAttrStorageNode
    extends Node {
        EnsureAttrStorageNode() {
        }

        abstract Object[] execute(PBaseException var1, StorageFactory var2);

        @Specialization
        static Object[] ensure(PBaseException self, StorageFactory storageFactory, @Bind Node inliningTarget, @Cached ExceptionNodes.GetArgsNode getArgsNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getInternalObjectArrayNode) {
            Object[] attributes = self.getExceptionAttributes();
            if (attributes == null) {
                PTuple argsTuple = getArgsNode.execute(inliningTarget, self);
                Object[] args = getInternalObjectArrayNode.execute(inliningTarget, argsTuple.getSequenceStorage());
                attributes = storageFactory.create(args);
                self.setExceptionAttributes(attributes);
            }
            return attributes;
        }
    }
}

