import type { TZclFrame } from "../../zspec/zcl/zclFrame";
import type Endpoint from "../model/endpoint";
import type { OtaDataSettings, OtaImage, OtaImageElement, OtaImageHeader, OtaSource, ZigbeeOtaImageMeta } from "../tstype";
export declare enum OtaTagId {
    UpgradeImage = 0,
    /** signer IEEE address (8-byte), signature data (42-byte) */
    ECDSASignatureCryptoSuite1 = 1,
    /** ECDSA certificate (48-byte) */
    ECDSASigningCertificateCryptoSuite1 = 2,
    /** hash value (16-byte) */
    ImageIntegrityCode = 3,
    /** */
    PictureData = 4,
    /** signer IEEE address (8-byte), signature data (72-byte) */
    ECDSASignatureCryptoSuite2 = 5,
    /** ECDSA certificate (74-byte) */
    ECDSASigningCertificateCryptoSuite2 = 6,
    /**
     * 2-byte header before actual `UpgradeImage`
     * see https://github.com/telink-semi/telink_zigbee_sdk/blob/d5bc2f7b0c1f8536fe21c8127ca680ea8214bc8e/tl_zigbee_sdk/zigbee/ota/ota.h#L38
     */
    TelinkAES = 61440
}
/** uint32 LE */
export declare const UPGRADE_FILE_IDENTIFIER = 200208670;
/**
 * Set the dataDir for relative path needs (firmware file, index) as well as override index if any.
 */
export declare function setOtaConfiguration(inDataDir: string, inOverrideIndexLocation: string | undefined): void;
export declare function getOtaFirmware(url: string, sha512: string | undefined): Promise<Buffer>;
export declare function getOtaIndex(source: OtaSource): Promise<ZigbeeOtaImageMeta[]>;
export declare function parseOtaHeader(buffer: Buffer): OtaImageHeader;
export declare function parseOtaSubElement(buffer: Buffer, position: number): [OtaImageElement, metaOffset: number];
export declare function parseOtaImage(buffer: Buffer): OtaImage;
export declare class OtaSession {
    #private;
    private readonly ieeeAddr;
    private readonly endpoint;
    private readonly image;
    private readonly onProgress;
    private readonly dataSettings;
    private readonly waitForOtaCommand;
    get startTime(): number;
    constructor(ieeeAddr: string, endpoint: Endpoint, image: OtaImage, onProgress: (progress: number, remaining: number) => void, dataSettings: OtaDataSettings, waitForOtaCommand: <Co extends string>(endpointId: number, commandId: number, transactionSequenceNumber: number | undefined, timeout: number) => {
        promise: Promise<TZclFrame<"genOta", Co>>;
        cancel: () => void;
    });
    run(): Promise<TZclFrame<"genOta", "upgradeEndRequest">>;
    private commandStream;
    private sendImageBlockResponse;
}
//# sourceMappingURL=ota.d.ts.map