/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.model;

import java.io.IOException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.dashboard.DBDashboardContext;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardRendererType;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRendererDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardUIRegistry;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.w3c.dom.Element;

public class DashboardItemViewSettings {
    private static final Log log = Log.getLog(DashboardItemViewSettings.class);
    private final DashboardConfiguration viewConfiguration;
    private String itemId;
    private DashboardItemConfiguration dashboardItem;
    private String viewTypeId;
    private int index;
    private float widthRatio;
    private long updatePeriod;
    private int maxItems;
    private long maxAge;
    private boolean legendVisible;
    private boolean gridVisible;
    private boolean domainTicksVisible;
    private boolean rangeTicksVisible;
    private String description;

    DashboardItemViewSettings(DashboardConfiguration viewConfiguration, DashboardItemConfiguration dashboardDescriptor, int index) throws DBException {
        this.viewConfiguration = viewConfiguration;
        this.dashboardItem = dashboardDescriptor;
        this.viewTypeId = dashboardDescriptor.getDashboardRenderer();
        this.index = index;
        this.widthRatio = dashboardDescriptor.getWidthRatio();
        this.updatePeriod = dashboardDescriptor.getUpdatePeriod();
        this.maxItems = dashboardDescriptor.getMaxItems();
        this.maxAge = dashboardDescriptor.getMaxAge();
        this.legendVisible = true;
        this.gridVisible = true;
        this.domainTicksVisible = true;
        this.rangeTicksVisible = true;
        this.description = dashboardDescriptor.getDescription();
    }

    public DashboardItemViewSettings(DashboardConfiguration viewConfiguration, String id, Element element) {
        this.viewConfiguration = viewConfiguration;
        this.itemId = id;
        this.viewTypeId = element.getAttribute("viewType");
        this.index = CommonUtils.toInt((Object)element.getAttribute("index"));
        this.widthRatio = (float)CommonUtils.toDouble((Object)element.getAttribute("widthRatio"));
        this.updatePeriod = CommonUtils.toLong((Object)element.getAttribute("updatePeriod"));
        this.maxItems = CommonUtils.toInt((Object)element.getAttribute("maxItems"));
        this.maxAge = CommonUtils.toLong((Object)element.getAttribute("maxAge"));
        this.legendVisible = CommonUtils.getBoolean((String)element.getAttribute("legendVisible"), (boolean)true);
        this.gridVisible = CommonUtils.getBoolean((String)element.getAttribute("gridVisible"), (boolean)true);
        this.domainTicksVisible = CommonUtils.getBoolean((String)element.getAttribute("domainTicksVisible"), (boolean)true);
        this.rangeTicksVisible = CommonUtils.getBoolean((String)element.getAttribute("rangeTicksVisible"), (boolean)true);
        this.description = element.getAttribute("description");
    }

    public DashboardItemViewSettings(DashboardItemViewSettings source) {
        this.viewConfiguration = source.viewConfiguration;
        this.copyFrom(source);
    }

    public DashboardConfiguration getViewConfiguration() {
        return this.viewConfiguration;
    }

    public DashboardItemConfiguration getDashboardItem() {
        return this.dashboardItem;
    }

    public String getItemId() {
        return this.dashboardItem == null ? this.itemId : this.dashboardItem.getId();
    }

    public String getFullDashboardId() {
        if (this.dashboardItem != null) {
            Object path = this.dashboardItem.getPath();
            path = path != null ? (String)path + "/" : "";
            return this.dashboardItem.getDashboardProvider().getId() + ":" + (String)path + this.dashboardItem.getId();
        }
        return this.itemId;
    }

    @Nullable
    public DashboardItemConfiguration getItemConfiguration() {
        if (this.dashboardItem == null) {
            try {
                DBPDataSourceContainer dataSourceContainer = this.viewConfiguration.getDataSourceContainer();
                this.dashboardItem = DashboardRegistry.getInstance().findDashboardItem((DBRProgressMonitor)new VoidProgressMonitor(), dataSourceContainer != null ? new DBDashboardContext(dataSourceContainer) : new DBDashboardContext(this.viewConfiguration.getProject()), this.itemId);
                if (this.dashboardItem == null) {
                    log.debug((Object)("Configuration item '" + this.itemId + "' not found in registry"));
                }
            }
            catch (DBException e) {
                log.debug((Object)("Dashboard '" + this.itemId + "' not found"), (Throwable)e);
                return null;
            }
        }
        return this.dashboardItem;
    }

    public DashboardRendererType getViewType() {
        String vtId = this.viewTypeId;
        if (CommonUtils.isEmpty((String)vtId)) {
            DashboardItemConfiguration dashboard = this.getItemConfiguration();
            vtId = dashboard == null ? "timeseries" : dashboard.getDashboardRenderer();
        }
        return DashboardUIRegistry.getInstance().getViewType(vtId);
    }

    public void setViewType(DashboardRendererType viewType) {
        this.viewTypeId = viewType.getId();
    }

    public float getWidthRatio() {
        return this.widthRatio;
    }

    public void setWidthRatio(float widthRatio) {
        this.widthRatio = widthRatio;
    }

    public long getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setUpdatePeriod(long updatePeriod) {
        this.updatePeriod = updatePeriod;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    public void setLegendVisible(boolean legendVisible) {
        this.legendVisible = legendVisible;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean gridVisible) {
        this.gridVisible = gridVisible;
    }

    public boolean isDomainTicksVisible() {
        return this.domainTicksVisible;
    }

    public void setDomainTicksVisible(boolean domainTicksVisible) {
        this.domainTicksVisible = domainTicksVisible;
    }

    public boolean isRangeTicksVisible() {
        return this.rangeTicksVisible;
    }

    public void setRangeTicksVisible(boolean rangeTicksVisible) {
        this.rangeTicksVisible = rangeTicksVisible;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    void copyFrom(DashboardItemViewSettings source) {
        this.dashboardItem = source.dashboardItem;
        this.viewTypeId = source.viewTypeId;
        this.index = source.index;
        this.widthRatio = source.widthRatio;
        this.updatePeriod = source.updatePeriod;
        this.maxItems = source.maxItems;
        this.maxAge = source.maxAge;
        this.legendVisible = source.legendVisible;
        this.gridVisible = source.gridVisible;
        this.domainTicksVisible = source.domainTicksVisible;
        this.rangeTicksVisible = source.rangeTicksVisible;
        this.description = source.description;
    }

    void serialize(XMLBuilder xml) throws IOException {
        DashboardRendererDescriptor viewType = DashboardUIRegistry.getInstance().getViewType(this.viewTypeId);
        boolean isNativeRenderer = viewType != null && viewType.isNativeRenderer();
        xml.addAttribute("id", this.getFullDashboardId());
        xml.addAttribute("viewType", this.viewTypeId);
        xml.addAttribute("index", this.index);
        xml.addAttribute("widthRatio", this.widthRatio);
        xml.addAttribute("updatePeriod", this.updatePeriod);
        if (isNativeRenderer) {
            xml.addAttribute("maxItems", this.maxItems);
            xml.addAttribute("maxAge", this.maxAge);
            xml.addAttribute("legendVisible", this.legendVisible);
            xml.addAttribute("gridVisible", this.gridVisible);
            xml.addAttribute("domainTicksVisible", this.domainTicksVisible);
            xml.addAttribute("rangeTicksVisible", this.rangeTicksVisible);
        }
        if (!CommonUtils.isEmpty((String)this.description)) {
            xml.addAttribute("description", this.description);
        }
    }

    public String toString() {
        return this.getItemId() + ":" + this.index;
    }
}

