/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OpenFileSearchPageAction
implements IWorkbenchWindowActionDelegate {
    private static final String TEXT_SEARCH_PAGE_ID = "org.eclipse.search.internal.ui.text.TextSearchPage";
    private IWorkbenchWindow fWindow;

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        if (this.fWindow == null || this.fWindow.getActivePage() == null) {
            SearchPlugin.beep();
            OpenFileSearchPageAction.logErrorMessage("Could not open the search dialog - for some reason the window handle was null");
            return;
        }
        NewSearchUI.openSearchDialog(this.fWindow, TEXT_SEARCH_PAGE_ID);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        this.fWindow = null;
    }

    public static void logErrorMessage(String message) {
        Status status = new Status(4, "org.eclipse.search", 4, message, null);
        SearchPlugin.log((IStatus)status);
    }
}

