/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories;

import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.ExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupSetExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdSetExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleSetExclude;

class Unions {
    private final ExcludeFactory factory;

    public Unions(ExcludeFactory factory) {
        this.factory = factory;
    }

    ExcludeSpec tryUnion(ExcludeSpec left, ExcludeSpec right) {
        if (left.equals(right)) {
            return left;
        }
        if (left instanceof ModuleExclude) {
            return this.tryModuleUnion((ModuleExclude)left, right);
        }
        if (right instanceof ModuleExclude) {
            return this.tryModuleUnion((ModuleExclude)right, left);
        }
        if (left instanceof GroupExclude) {
            return this.tryGroupUnion((GroupExclude)left, right);
        }
        if (right instanceof GroupExclude) {
            return this.tryGroupUnion((GroupExclude)right, left);
        }
        if (left instanceof ModuleSetExclude) {
            return this.tryModuleSetUnion((ModuleSetExclude)left, right);
        }
        if (right instanceof ModuleSetExclude) {
            return this.tryModuleSetUnion((ModuleSetExclude)right, left);
        }
        if (left instanceof GroupSetExclude) {
            return this.tryGroupSetUnion((GroupSetExclude)left, right);
        }
        if (right instanceof GroupSetExclude) {
            return this.tryGroupSetUnion((GroupSetExclude)right, left);
        }
        return null;
    }

    private ExcludeSpec tryModuleUnion(ModuleExclude left, ExcludeSpec right) {
        ModuleIdExclude mie;
        String leftModule = left.getModule();
        if (right instanceof ModuleIdExclude && (mie = (ModuleIdExclude)right).getModuleId().getName().equals(leftModule)) {
            return left;
        }
        if (right instanceof ModuleIdSetExclude) {
            ModuleIdSetExclude ids = (ModuleIdSetExclude)right;
            Set<ModuleIdentifier> items = ids.getModuleIds().stream().filter(id -> !id.getName().equals(leftModule)).collect(Collectors.toSet());
            if (items.size() == 1) {
                return this.factory.anyOf(left, this.factory.moduleId((ModuleIdentifier)items.iterator().next()));
            }
            if (items.isEmpty()) {
                return left;
            }
            if (items.size() != ids.getModuleIds().size()) {
                return this.factory.anyOf(left, this.factory.moduleIdSet(items));
            }
        }
        return null;
    }

    private ExcludeSpec tryGroupUnion(GroupExclude left, ExcludeSpec right) {
        ModuleIdExclude mie;
        String leftGroup = left.getGroup();
        if (right instanceof ModuleIdExclude && (mie = (ModuleIdExclude)right).getModuleId().getGroup().equals(leftGroup)) {
            return left;
        }
        if (right instanceof ModuleIdSetExclude) {
            ModuleIdSetExclude ids = (ModuleIdSetExclude)right;
            Set<ModuleIdentifier> items = ids.getModuleIds().stream().filter(id -> !id.getGroup().equals(leftGroup)).collect(Collectors.toSet());
            if (items.size() == 1) {
                return this.factory.anyOf(left, this.factory.moduleId((ModuleIdentifier)items.iterator().next()));
            }
            if (items.isEmpty()) {
                return left;
            }
            if (items.size() != ids.getModuleIds().size()) {
                return this.factory.anyOf(left, this.factory.moduleIdSet(items));
            }
        }
        return null;
    }

    private ExcludeSpec tryModuleSetUnion(ModuleSetExclude left, ExcludeSpec right) {
        ModuleIdExclude mie;
        Set<String> leftModules = left.getModules();
        if (right instanceof ModuleIdExclude && leftModules.contains((mie = (ModuleIdExclude)right).getModuleId().getName())) {
            return left;
        }
        if (right instanceof ModuleIdSetExclude) {
            ModuleIdSetExclude ids = (ModuleIdSetExclude)right;
            Set<ModuleIdentifier> items = ids.getModuleIds().stream().filter(id -> !leftModules.contains(id.getName())).collect(Collectors.toSet());
            if (items.size() == 1) {
                return this.factory.anyOf(left, this.factory.moduleId((ModuleIdentifier)items.iterator().next()));
            }
            if (items.isEmpty()) {
                return left;
            }
            if (items.size() != ids.getModuleIds().size()) {
                return this.factory.anyOf(left, this.factory.moduleIdSet(items));
            }
        }
        return null;
    }

    private ExcludeSpec tryGroupSetUnion(GroupSetExclude left, ExcludeSpec right) {
        ModuleIdExclude mie;
        Set<String> leftGroups = left.getGroups();
        if (right instanceof ModuleIdExclude && leftGroups.contains((mie = (ModuleIdExclude)right).getModuleId().getGroup())) {
            return left;
        }
        if (right instanceof ModuleIdSetExclude) {
            ModuleIdSetExclude ids = (ModuleIdSetExclude)right;
            Set<ModuleIdentifier> items = ids.getModuleIds().stream().filter(id -> !leftGroups.contains(id.getGroup())).collect(Collectors.toSet());
            if (items.size() == 1) {
                return this.factory.anyOf(left, this.factory.moduleId((ModuleIdentifier)items.iterator().next()));
            }
            if (items.isEmpty()) {
                return left;
            }
            if (items.size() != ids.getModuleIds().size()) {
                return this.factory.anyOf(left, this.factory.moduleIdSet(items));
            }
        }
        return null;
    }
}

