/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.internal.service.DefaultServiceAccessToken;
import org.gradle.internal.service.ServiceAccessScope;
import org.gradle.internal.service.ServiceAccessToken;
import org.jspecify.annotations.Nullable;

class ServiceAccess {
    private static final ServiceAccessScope PUBLIC = new ServiceAccessScope(){

        @Override
        public boolean contains(@Nullable ServiceAccessToken token) {
            return true;
        }

        public String toString() {
            return "Public";
        }
    };
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);

    private ServiceAccess() {
    }

    public static ServiceAccessToken createToken(String ownerDisplayName) {
        return new DefaultServiceAccessToken(NEXT_ID.incrementAndGet(), ownerDisplayName);
    }

    public static ServiceAccessScope getPublicScope() {
        return PUBLIC;
    }

    public static ServiceAccessScope getPrivateScope(ServiceAccessToken token) {
        return new PrivateAccessScope(token);
    }

    private static class PrivateAccessScope
    implements ServiceAccessScope {
        private final ServiceAccessToken ownerToken;

        public PrivateAccessScope(ServiceAccessToken ownerToken) {
            this.ownerToken = ownerToken;
        }

        @Override
        public boolean contains(@Nullable ServiceAccessToken token) {
            return this.ownerToken.equals(token);
        }

        public String toString() {
            return "Private(" + this.ownerToken + ")";
        }
    }
}

