## ----echo=FALSE, results="hide", message=FALSE--------------------------------
require(knitr)
opts_chunk$set(error=FALSE, message=FALSE, warning=FALSE)

library(BiocStyle)
self <- Biocpkg("biocmake")

## -----------------------------------------------------------------------------
biocmake::find()

## -----------------------------------------------------------------------------
project <- tempfile()
dir.create(project)

write(file=file.path(project, "CMakeLists.txt"), '
cmake_minimum_required(VERSION 3.25)

project(bctest VERSION 2.0.1 LANGUAGES CXX)

add_library(superfoo src/superfoo.cpp)
target_include_directories(superfoo PUBLIC include)
')

dir.create(file.path(project, "src"))
write(file=file.path(project, "src", "superfoo.cpp"), '
int superfoo(int a, int b) {
    return a + b;
}
')

dir.create(file.path(project, "include"))
write(file=file.path(project, "include", "superfoo.h"), '
#ifndef SUPERFOO_H
#define SUPERFOO_H

int superfoo(int, int);

#endif
')

## -----------------------------------------------------------------------------
# Removing some of the configuration parameters that we don't need.
config <- biocmake::configure(c.compiler=FALSE, fortran.compiler=FALSE)
config.args <- biocmake::formatArguments(config)

cmake <- biocmake::find()
build <- tempfile()
status <- system2(cmake, c(config.args, "-S", project, "-B", build))
stopifnot(status == 0L)

status <- system2(cmake, c("--build", build))
stopifnot(status == 0L)

## -----------------------------------------------------------------------------
biocmake::defaultCommand()
biocmake::defaultMinimumVersion()
biocmake::defaultDownloadVersion()
biocmake::defaultCacheDirectory()

## -----------------------------------------------------------------------------
Sys.setenv(BIOCMAKE_CMAKE_MINIMUM_VERSION="3.27.4")
biocmake::defaultMinimumVersion()

## -----------------------------------------------------------------------------
sessionInfo()

