/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.io.LineBufferedOutputStream;
import edu.rit.pj.cluster.BackendFileOutputStream;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class BackendFileWriter {
    public final PrintStream out;
    public final PrintStream err;
    private JobFrontendRef myJobFrontend;
    private JobBackendRef myJobBackend;
    private Map<Integer, BackendFileOutputStream> myOutputStreamForBFD = new HashMap<Integer, BackendFileOutputStream>();
    private Map<Integer, BackendFileOutputStream> myOutputStreamForFFD = new HashMap<Integer, BackendFileOutputStream>();
    private int myNextBFD = 1;

    public BackendFileWriter(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) {
        this.myJobFrontend = jobFrontendRef;
        this.myJobBackend = jobBackendRef;
        BackendFileOutputStream backendFileOutputStream = new BackendFileOutputStream(this.myJobFrontend, this.myJobBackend, 1);
        BackendFileOutputStream backendFileOutputStream2 = new BackendFileOutputStream(this.myJobFrontend, this.myJobBackend, 2);
        this.myOutputStreamForFFD.put(1, backendFileOutputStream);
        this.myOutputStreamForFFD.put(2, backendFileOutputStream2);
        this.out = new PrintStream(new LineBufferedOutputStream(backendFileOutputStream), true);
        this.err = new PrintStream(new LineBufferedOutputStream(backendFileOutputStream2), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackendFileOutputStream open(File file, boolean bl) throws IOException {
        BackendFileOutputStream backendFileOutputStream = null;
        int n = 0;
        int n2 = 0;
        BackendFileWriter backendFileWriter = this;
        synchronized (backendFileWriter) {
            backendFileOutputStream = new BackendFileOutputStream(this.myJobFrontend, this.myJobBackend);
            n = this.myNextBFD++;
            this.myOutputStreamForBFD.put(n, backendFileOutputStream);
        }
        n2 = backendFileOutputStream.open(n, file, bl);
        backendFileWriter = this;
        synchronized (backendFileWriter) {
            this.myOutputStreamForFFD.put(n2, backendFileOutputStream);
        }
        return backendFileOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileOpenResult(JobFrontendRef jobFrontendRef, int n, int n2, IOException iOException) {
        BackendFileOutputStream backendFileOutputStream = null;
        BackendFileWriter backendFileWriter = this;
        synchronized (backendFileWriter) {
            backendFileOutputStream = this.myOutputStreamForBFD.remove(n);
        }
        if (backendFileOutputStream != null) {
            backendFileOutputStream.putResult(n2, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileWriteResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
        BackendFileOutputStream backendFileOutputStream = null;
        BackendFileWriter backendFileWriter = this;
        synchronized (backendFileWriter) {
            backendFileOutputStream = this.myOutputStreamForFFD.get(n);
        }
        if (backendFileOutputStream != null) {
            backendFileOutputStream.putResult(n, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileFlushResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
        BackendFileOutputStream backendFileOutputStream = null;
        BackendFileWriter backendFileWriter = this;
        synchronized (backendFileWriter) {
            backendFileOutputStream = this.myOutputStreamForFFD.get(n);
        }
        if (backendFileOutputStream != null) {
            backendFileOutputStream.putResult(n, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileCloseResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
        BackendFileOutputStream backendFileOutputStream = null;
        BackendFileWriter backendFileWriter = this;
        synchronized (backendFileWriter) {
            backendFileOutputStream = this.myOutputStreamForFFD.remove(n);
        }
        if (backendFileOutputStream != null) {
            backendFileOutputStream.putResult(n, iOException);
        }
    }
}

