/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.Partitioning;
import cern.colt.Timer;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleFactory3D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.doublealgo.Sorting;
import cern.colt.matrix.impl.AbstractMatrix;
import cern.colt.xPartitioningOld;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import jal.INT.Modification;

class PartitioningTest {
    protected PartitioningTest() {
    }

    public static void benchmarkPartition(int n, int n2, int n3, boolean bl, boolean bl2) {
        System.out.println("\n\n");
        Uniform uniform = new Uniform(new MersenneTwister());
        System.out.println("initializing...");
        int[] nArray = new int[n2];
        int n4 = Math.max(n2, n3);
        int n5 = 0;
        while (n5 < n2) {
            nArray[n5] = !bl ? uniform.nextIntFromTo(0, n4) : -10000000;
            ++n5;
        }
        int[] nArray2 = new int[n3];
        int n6 = 0;
        while (n6 < n3) {
            nArray2[n6] = (int)Math.round((double)n4 / (double)n3 * ((double)n6 + 0.5));
            ++n6;
        }
        IntArrayList intArrayList = new IntArrayList(nArray);
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = intArrayList.copy();
        IntArrayList intArrayList4 = new IntArrayList(nArray2);
        IntArrayList intArrayList5 = new IntArrayList(new int[intArrayList4.size()]);
        System.out.println("warming up...");
        intArrayList2.addAllOfFromTo(intArrayList, 0, n2 - 1);
        if (bl2) {
            Partitioning.partition(intArrayList2, 0, n2 - 1, intArrayList4, intArrayList5);
            Partitioning.steps = 0;
            Partitioning.swappedElements = 0;
        } else {
            xPartitioningOld.partition(intArrayList2, 0, n2 - 1, intArrayList4, intArrayList5);
            xPartitioningOld.steps = 0;
            xPartitioningOld.swappedElements = 0;
        }
        System.out.println("now benchmarking...");
        Timer timer = new Timer();
        int n7 = 0;
        while (n7 < n) {
            timer.start();
            intArrayList2.clear();
            intArrayList2.addAllOfFromTo(intArrayList, 0, n2 - 1);
            if (bl2) {
                Partitioning.partition(intArrayList2, 0, n2 - 1, intArrayList4, intArrayList5);
            } else {
                xPartitioningOld.partition(intArrayList2, 0, n2 - 1, intArrayList4, intArrayList5);
            }
            timer.stop();
            ++n7;
        }
        timer.display();
        if (bl2) {
            System.out.println("steps=" + Partitioning.steps);
            System.out.println("swappedElements=" + Partitioning.swappedElements);
        } else {
            System.out.println("steps=" + xPartitioningOld.steps);
            System.out.println("swappedElements=" + xPartitioningOld.swappedElements);
        }
        System.out.println("bye bye.");
    }

    public static void benchmarkPartitionDouble(int n, int n2, int n3, boolean bl) {
        System.out.println("\n\n");
        Uniform uniform = new Uniform(new MersenneTwister());
        System.out.println("initializing...");
        double[] dArray = new double[n2];
        int n4 = 0;
        while (n4 < n2) {
            dArray[n4] = !bl ? (double)uniform.nextIntFromTo(0, n2) : -1.0E7;
            ++n4;
        }
        double[] dArray2 = new double[n3];
        int n5 = 0;
        while (n5 < n3) {
            dArray2[n5] = (int)Math.round((double)n2 / (double)n3 * ((double)n5 + 0.5));
            ++n5;
        }
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray);
        DoubleArrayList doubleArrayList2 = new DoubleArrayList();
        DoubleArrayList doubleArrayList3 = new DoubleArrayList(dArray2);
        IntArrayList intArrayList = new IntArrayList(new int[doubleArrayList3.size()]);
        doubleArrayList2 = new DoubleArrayList();
        DoubleArrayList doubleArrayList4 = new DoubleArrayList(dArray).copy();
        System.out.println("warming up...");
        doubleArrayList2.addAllOfFromTo(doubleArrayList, 0, n2 - 1);
        xPartitioningOld.dualPartition(doubleArrayList2.elements(), doubleArrayList4.elements(), 0, doubleArrayList2.size() - 1, doubleArrayList3.elements(), 0, doubleArrayList3.size() - 1, intArrayList.elements());
        Timer timer = new Timer();
        int n6 = 0;
        while (n6 < n) {
            doubleArrayList2.clear();
            doubleArrayList2.addAllOfFromTo(doubleArrayList, 0, n2 - 1);
            timer.start();
            xPartitioningOld.dualPartition(doubleArrayList2.elements(), doubleArrayList4.elements(), 0, doubleArrayList2.size() - 1, doubleArrayList3.elements(), 0, doubleArrayList3.size() - 1, intArrayList.elements());
            timer.stop();
            ++n6;
        }
        timer.display();
        System.out.println("bye bye.");
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        boolean bl = new Boolean(stringArray[3]);
        String string = stringArray[4];
        boolean bl2 = stringArray[5].equals("new");
        if (string.equals("int")) {
            PartitioningTest.benchmarkPartition(n, n2, n3, bl, bl2);
        }
        if (string.equals("double")) {
            PartitioningTest.benchmarkPartitionDouble(n, n2, n3, bl);
        }
    }

    public static void testPartition() {
        System.out.println("\n\n");
        AbstractMatrix abstractMatrix = DoubleFactory2D.dense.descending(4, 2);
        double[] dArray = new double[]{5.0, 10.0, 12.0};
        DoubleMatrix1D doubleMatrix1D = abstractMatrix.viewColumn(0);
        int[] nArray = new int[dArray.length];
        System.out.println(abstractMatrix);
        System.out.println("col1=" + doubleMatrix1D);
        double[] dArray2 = doubleMatrix1D.toArray();
        System.out.println("col2=" + new DoubleArrayList(dArray2));
        System.out.println("col3=" + new DoubleArrayList(dArray2));
        System.out.println("sorted1=" + Sorting.quickSort(abstractMatrix, 0));
        System.out.println(cern.colt.matrix.doublealgo.Partitioning.partition(abstractMatrix, 0, dArray, nArray));
        System.out.println("splitters=" + new DoubleArrayList(dArray));
        System.out.println("splitIndexes=" + new IntArrayList(nArray));
        System.out.println(abstractMatrix);
        abstractMatrix = DoubleFactory3D.dense.descending(4, 2, 3);
        System.out.println(abstractMatrix);
        System.out.println("sorted1=" + Sorting.quickSort((DoubleMatrix3D)abstractMatrix, 0, 0));
        System.out.println(abstractMatrix);
    }

    public static void testPartition(IntArrayList intArrayList, int n, int n2, IntArrayList intArrayList2) {
        int n3;
        int n4;
        IntArrayList intArrayList3 = new IntArrayList(intArrayList2.size());
        intArrayList3.setSize(intArrayList2.size());
        IntArrayList intArrayList4 = intArrayList.copy();
        Partitioning.partition(intArrayList4.elements(), n, n2, intArrayList2.elements(), 0, intArrayList2.size() - 1, intArrayList3.elements());
        int n5 = Integer.MIN_VALUE;
        int n6 = n - 1;
        int n7 = 0;
        while (n7 < intArrayList2.size()) {
            n4 = intArrayList2.get(n7);
            int n8 = intArrayList3.get(n7);
            n3 = n6 + 1;
            while (n3 <= n8) {
                if (n5 > intArrayList4.get(n3) || intArrayList4.get(n3) >= n4) {
                    throw new RuntimeException("bug detected");
                }
                ++n3;
            }
            n5 = n4;
            n6 = n8;
            ++n7;
        }
        n4 = 1 + n6;
        while (n4 <= n2) {
            if (n5 > intArrayList4.get(n4) || intArrayList4.get(n4) > Integer.MAX_VALUE) {
                System.out.println("list   =" + intArrayList.partFromTo(n, n2));
                System.out.println("partial=" + intArrayList4.partFromTo(n, n2));
                System.out.println("splitters=" + intArrayList2);
                System.out.println("splitIndexes=" + intArrayList3);
                System.out.println("j=" + n4);
                System.out.println("element[j]=" + intArrayList4.get(n4));
                System.out.println("lastSplitter=" + n5);
                throw new RuntimeException("bug detected");
            }
            ++n4;
        }
        intArrayList4.sortFromTo(n, n2);
        IntArrayList intArrayList5 = intArrayList.copy();
        intArrayList5.sortFromTo(n, n2);
        n3 = intArrayList.size();
        if (n3 != intArrayList4.size() || !jal.INT.Sorting.includes(intArrayList4.elements(), intArrayList5.elements(), n, n2 + 1, n, n2 + 1) || !jal.INT.Sorting.includes(intArrayList5.elements(), intArrayList4.elements(), n, n2 + 1, n, n2 + 1)) {
            System.out.println("sortedList=" + intArrayList5.partFromTo(n, n2));
            System.out.println("partiallySorted=" + intArrayList4.partFromTo(n, n2));
            throw new RuntimeException("bug detected");
        }
    }

    public static void testPartitionRandomly(int n) {
        MersenneTwister mersenneTwister = new MersenneTwister();
        Uniform uniform = new Uniform(mersenneTwister);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            int n5 = 50;
            int n6 = 2 * n5;
            int n7 = uniform.nextIntFromTo(0, n5);
            if (n7 == 0) {
                n4 = 0;
                n3 = -1;
            } else {
                n4 = uniform.nextIntFromTo(0, n7 - 1);
                n3 = uniform.nextIntFromTo(Math.min(n4, n7 - 1), n7 - 1);
            }
            int n8 = uniform.nextIntFromTo(n7 / 2, 2 * n7);
            int n9 = uniform.nextIntFromTo(n8, 2 * n7);
            IntArrayList intArrayList = new IntArrayList(n7);
            int n10 = 0;
            while (n10 < n7) {
                intArrayList.add(uniform.nextIntFromTo(n8, n9));
                ++n10;
            }
            int n11 = uniform.nextIntFromTo(0, n6);
            IntArrayList intArrayList2 = new IntArrayList(n11);
            int n12 = 0;
            while (n12 < n11) {
                intArrayList2.add(uniform.nextIntFromTo(n8 / 2, 2 * n9));
                ++n12;
            }
            intArrayList2.sort();
            n11 = Modification.unique(intArrayList2.elements(), 0, n11);
            intArrayList2.setSize(n11);
            PartitioningTest.testPartition(intArrayList, n4, n3, intArrayList2);
            ++n2;
        }
        System.out.println("All tests passed. No bug detected.");
    }
}

