## ----echo=FALSE---------------------------------------------------------------
source(system.file('vignettes_inc.R', package='biodb'))

## -----------------------------------------------------------------------------
mybiodb <- biodb::BiodbMain$new()

## ----echo=FALSE, results='asis'-----------------------------------------------
make_vignette_ref('new_connector')

## ----echo=FALSE, results='asis'-----------------------------------------------
make_vignette_ref('new_connector')

## ----echo=FALSE, results='asis'-----------------------------------------------
make_vignette_ref('new_connector')

## -----------------------------------------------------------------------------
chebiexDefFile <- system.file("extdata", "chebi_ex.yml", package='biodb')
connClass <- system.file("extdata", "ChebiExConn.R", package='biodb')
entryClass <- system.file("extdata", "ChebiExEntry.R", package='biodb')
source(connClass)
source(entryClass)
mybiodb$loadDefinitions(chebiexDefFile)

## -----------------------------------------------------------------------------
conn <- mybiodb$getFactory()$createConn('chebi.ex')

## -----------------------------------------------------------------------------
entryIds <- c('17001', '40304', '64679')
entriesDf <- mybiodb$entriesToDataframe(conn$getEntry(entryIds))

## ----entriesChebiExTable, echo=FALSE, results='asis'--------------------------
# Prevent RMarkdown from interpreting @ character as a reference:
entriesDf$smiles <- vapply(entriesDf$smiles, function(s) paste0('`', s, '`'), FUN.VALUE='')
knitr::kable(head(entriesDf), "pipe", caption="Some entries from ChebiEx database. Their charge value is not visible become it was not parsed from database file.")

## -----------------------------------------------------------------------------
id <- entryIds[[1]]
id

## -----------------------------------------------------------------------------
conn$getEntryPageUrl(id)

## ----echo=FALSE, results='asis'-----------------------------------------------
cat("<", conn$getEntryPageUrl(id), ">", sep='')

## -----------------------------------------------------------------------------
conn$getCacheFile(id)

## -----------------------------------------------------------------------------
chargeParsingDefFile <- system.file("extdata", "chebi_ex_charge_parsing.yml", package='biodb')

## ----eval=FALSE, highlight=FALSE, code=readLines(chargeParsingDefFile)--------
# databases:
#   chebi.ex:
#     parsing.expr:
#       charge: //chebi:charge

## -----------------------------------------------------------------------------
mybiodb$loadDefinitions(chargeParsingDefFile)

## -----------------------------------------------------------------------------
mybiodb$getFactory()$deleteConn(conn)

## -----------------------------------------------------------------------------
conn <- mybiodb$getFactory()$createConn('chebi.ex')
entriesDf <- mybiodb$entriesToDataframe(conn$getEntry(entryIds))

## ----entriesChebiExWithChargeTable, echo=FALSE, results='asis'----------------
# Prevent RMarkdown from interpreting @ character as a reference:
entriesDf$smiles <- vapply(entriesDf$smiles, function(s) paste0('`', s, '`'), FUN.VALUE='')
knitr::kable(head(entriesDf), "pipe", caption="Some entries from ChebiEx database. Their charge value is now visible, since the parsing expression has been added to the connector.")

## ----echo=FALSE, results='asis'-----------------------------------------------
make_vignette_ref('in_house_compound_db')

## -----------------------------------------------------------------------------
fileUrl <- system.file("extdata", "chebi_extract_with_unknown_column.tsv", package='biodb')

## ----compDbTable, echo=FALSE, results='asis'----------------------------------
compDbDf <- read.table(fileUrl, sep="\t", header=TRUE, quote="")
# Prevent RMarkdown from interpreting @ character as a reference:
compDbDf$smiles <- vapply(compDbDf$smiles, function(s) paste0('`', s, '`'), FUN.VALUE='')
knitr::kable(head(compDbDf), "pipe", caption="First lines of the compound database file.")

## -----------------------------------------------------------------------------
conn <- mybiodb$getFactory()$createConn('comp.csv.file', url=fileUrl)

## -----------------------------------------------------------------------------
entriesDf <- mybiodb$entriesToDataframe(conn$getEntry(conn$getEntryIds()))

## ----entriesTable, echo=FALSE, results='asis'---------------------------------
# Prevent RMarkdown from interpreting @ character as a reference:
entriesDf$smiles <- vapply(entriesDf$smiles, function(s) paste0('`', s, '`'), FUN.VALUE='')
knitr::kable(head(entriesDf), "pipe", caption="Some entries from the compound database.")

## -----------------------------------------------------------------------------
conn$setField('charge', 'elecCharge')

## -----------------------------------------------------------------------------
conn$deleteAllEntriesFromVolatileCache()

## -----------------------------------------------------------------------------
entries2Df <- mybiodb$entriesToDataframe(conn$getEntry(conn$getEntryIds()))

## ----entries2Table, echo=FALSE, results='asis'--------------------------------
# Prevent RMarkdown from interpreting @ character as a reference:
entries2Df$smiles <- vapply(entries2Df$smiles, function(s) paste0('`', s, '`'), FUN.VALUE='')
knitr::kable(head(entries2Df), "pipe", caption="Some entries from the compound database. They now show the newly parsed \"charge\" field.")

## ----echo=FALSE, results='asis'-----------------------------------------------
make_vignette_ref('new_connector')

## -----------------------------------------------------------------------------
conn <- mybiodb$getFactory()$getConn('chebi.ex')
entryIds <- c('17001', '40304', '64679')
entriesDf <- mybiodb$entriesToDataframe(conn$getEntry(entryIds))

## ----entriesChebiEx2Table, echo=FALSE, results='asis'-------------------------
# Prevent RMarkdown from interpreting @ character as a reference:
entriesDf$smiles <- vapply(entriesDf$smiles, function(s) paste0('`', s, '`'), FUN.VALUE='')
knitr::kable(head(entriesDf), "pipe", caption="Some entries from ChebiEx database. There is no field that indicates the number of stars of an entry.")

## -----------------------------------------------------------------------------
nStarsDefFile <- system.file("extdata", "chebi_ex_stars_field.yml", package='biodb')

## ----eval=FALSE, highlight=FALSE, code=readLines(nStarsDefFile)---------------
# databases:
#   chebi.ex:
#     parsing.expr:
#       n_stars: //chebi:return/chebi:entityStar
# 
# fields:
#   n_stars:
#     description: The ChEBI example stars indicator.
#     class: integer

## -----------------------------------------------------------------------------
mybiodb$loadDefinitions(nStarsDefFile)

## -----------------------------------------------------------------------------
mybiodb$getFactory()$deleteConn(conn)

## -----------------------------------------------------------------------------
conn <- mybiodb$getFactory()$createConn('chebi.ex')
entriesDf <- mybiodb$entriesToDataframe(conn$getEntry(entryIds))

## ----entriesChebiEx2WithNstarsTable, echo=FALSE, results='asis'---------------
# Prevent RMarkdown from interpreting @ character as a reference:
entriesDf$smiles <- vapply(entriesDf$smiles, function(s) paste0('`', s, '`'), FUN.VALUE='')
knitr::kable(head(entriesDf), "pipe", caption="Some entries from ChebiEx database. Now there is a n_stars no field that indicates the number of stars of an entry.")

## -----------------------------------------------------------------------------
mybiodb$terminate()

## -----------------------------------------------------------------------------
sessionInfo()

