/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.monte;

import edu.rit.crypto.blockcipher.AES256Cipher;
import edu.rit.numeric.Statistics;
import edu.rit.pj.Comm;
import edu.rit.util.Hex;
import java.util.Arrays;

public class AesTestSeq {
    static byte[] key = new byte[32];
    static int N;
    static AES256Cipher cipher;
    static byte[] plaintext;
    static byte[] ciphertext;
    static double[] data;
    static double TWO_SUP_64;

    private AesTestSeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        Comm.init(stringArray);
        if (stringArray.length != 2) {
            AesTestSeq.usage();
        }
        Hex.toByteArray(stringArray[0], key);
        N = Integer.parseInt(stringArray[1]);
        cipher = new AES256Cipher(key);
        data = new double[N];
        TWO_SUP_64 = 2.0;
        TWO_SUP_64 *= TWO_SUP_64;
        TWO_SUP_64 *= TWO_SUP_64;
        TWO_SUP_64 *= TWO_SUP_64;
        TWO_SUP_64 *= TWO_SUP_64;
        TWO_SUP_64 *= TWO_SUP_64;
        TWO_SUP_64 *= TWO_SUP_64;
        for (int i = 0; i < N; ++i) {
            AesTestSeq.longToBytes(i, plaintext, 8);
            cipher.encrypt(plaintext, ciphertext);
            AesTestSeq.data[i] = AesTestSeq.bytesToDouble(ciphertext, 0);
        }
        Arrays.sort(data);
        double d = N;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < N; ++i) {
            double d4 = (double)(i + 1) / d;
            double d5 = data[i];
            d2 = Math.max(d2, Math.abs(d5 - d3));
            d2 = Math.max(d2, Math.abs(d5 - d4));
            d3 = d4;
        }
        double d6 = Statistics.ksPvalue(N, d2);
        System.out.println("N = " + N);
        System.out.println("D = " + d2);
        System.out.println("P = " + d6);
        System.out.println((l += System.currentTimeMillis()) + " msec");
    }

    private static void longToBytes(long l, byte[] byArray, int n) {
        for (int i = 7; i >= 0; --i) {
            byArray[n + i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
    }

    private static double bytesToDouble(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = l << 8 | (long)(byArray[n + i] & 0xFF);
        }
        return (double)l / TWO_SUP_64 + 0.5;
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.monte.AesTestSeq <key> <N>");
        System.err.println("<key> = Block cipher key");
        System.err.println("<N> = Number of blocks");
        System.exit(1);
    }

    static {
        plaintext = new byte[16];
        ciphertext = new byte[16];
    }
}

