/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.javautils;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.gkano.bioinfo.var.GeneralTools;
import com.gkano.bioinfo.var.Logger;
import com.gkano.bioinfo.vcf.SNPEncoder;
import com.gkano.bioinfo.vcf.VCFManager;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Parameters(commandDescription="VCF2DIST")
public class UtilVCF2DIST {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"-v", "--verbose"})
    private boolean verbose = false;
    @Parameter(description="<positional input files>")
    private List<String> positionalInputFiles = new ArrayList<String>();
    @Parameter(names={"-i", "--input"}, description="VCF input file(s)", variableArity=true)
    private List<String> namedInputFiles = new ArrayList<String>();
    @Parameter(names={"-o", "--output"}, description="Distance output file")
    private String outputFile;
    @Parameter(names={"--numberOfThreads", "-t"})
    private int numOfThreads = 1;

    public static String getUtilName() {
        return "VCF2DIST";
    }

    public void go() {
        try (PrintStream ops = GeneralTools.getPrintStreamOrExit(this.outputFile, this);){
            VCFManager<String> vcfm = new VCFManager<String>(Stream.concat(this.positionalInputFiles.stream(), this.namedInputFiles.stream()).collect(Collectors.toList()), this.numOfThreads, SNPEncoder.StringToStringParser, this.verbose);
            vcfm.init();
            new Thread(vcfm).start();
            vcfm.awaitFinalization();
            float[][] distances = vcfm.reduceDotProdToDistances();
            List<String> sampleNames = vcfm.getSampleNames();
            int N = sampleNames.size();
            ops.println(N + "\t" + vcfm.getNumVariants());
            for (int i = 0; i < N; ++i) {
                ops.print(sampleNames.get(i));
                for (int j = 0; j < N; ++j) {
                    ops.print("\t" + GeneralTools.decimalFormat.format(distances[i][j]));
                }
                ops.println();
            }
            ops.close();
        }
        catch (InterruptedException e) {
            Logger.error(this, e.getMessage());
            System.exit(1);
        }
    }
}

