/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.IOException;
import java.util.ArrayList;
import org.biojava.bio.seq.io.SubArraySymbolList;
import org.biojava.bio.seq.io.SymbolReader;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;

class ChunkedSymbolList
extends AbstractSymbolList {
    private Symbol[][] chunks;
    private final int chunkSize;
    private Alphabet alpha;
    private int length;
    private static final int CHUNK_SIZE = 16384;

    public ChunkedSymbolList(Symbol[][] symbolArray, int n, int n2, Alphabet alphabet) {
        this.chunks = symbolArray;
        this.chunkSize = n;
        this.length = n2;
        this.alpha = alphabet;
        alphabet.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.alpha.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public int length() {
        return this.length;
    }

    public static SymbolList make(SymbolReader symbolReader) throws IOException, IllegalSymbolException {
        ArrayList<Symbol[]> arrayList = new ArrayList<Symbol[]>();
        Symbol[] symbolArray = new Symbol[16384];
        int n = 0;
        while (symbolReader.hasMoreSymbols()) {
            if (n == 16384) {
                arrayList.add(symbolArray);
                symbolArray = new Symbol[16384];
                n = 0;
            }
            int n2 = symbolReader.readSymbols(symbolArray, n, 16384 - n);
            n += n2;
        }
        if (n > 0) {
            if (n < 16384) {
                Symbol[] symbolArray2 = symbolArray;
                symbolArray = new Symbol[n];
                System.arraycopy(symbolArray2, 0, symbolArray, 0, n);
            }
            arrayList.add(symbolArray);
        }
        if (arrayList.size() == 1) {
            return new SubArraySymbolList((Symbol[])arrayList.get(0), n, 0, symbolReader.getAlphabet());
        }
        Symbol[][] symbolArray3 = new Symbol[arrayList.size()][];
        int n3 = 0;
        while (n3 < arrayList.size()) {
            symbolArray3[n3] = (Symbol[])arrayList.get(n3);
            ++n3;
        }
        int n4 = (arrayList.size() - 1) * 16384 + n;
        return new ChunkedSymbolList(symbolArray3, 16384, n4, symbolReader.getAlphabet());
    }

    public SymbolList subList(int n, int n2) {
        int n3 = n2 - 1;
        int n4 = n - 1;
        int n5 = n4 / this.chunkSize;
        if (n3 / this.chunkSize == n5) {
            return new SubArraySymbolList(this.chunks[n5], n2 - n + 1, n4 % this.chunkSize, this.getAlphabet());
        }
        return super.subList(n, n2);
    }

    public Symbol symbolAt(int n) {
        try {
            int n2 = --n / this.chunkSize;
            int n3 = n % this.chunkSize;
            return this.chunks[n2][n3];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IndexOutOfBoundsException("Attempted to access symbol at " + ++n + " of ChunkedSymbolList length " + this.length);
        }
    }
}

