/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.Instruction;

class StringConstantInstruction
implements Instruction {
    private String s;

    StringConstantInstruction(String string) {
        if (string == null) {
            throw new NullPointerException("Can't make a StringConstantInstruction for a null string");
        }
        this.s = string;
    }

    public void writeCode(CodeContext codeContext) throws CodeException {
        int n = codeContext.getConstants().resolveString(this.s);
        if (n < 256) {
            codeContext.writeByte((byte)18);
            codeContext.writeByte((byte)n);
        } else {
            codeContext.writeByte((byte)19);
            codeContext.writeShort(n);
        }
    }
}

