/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier;

import edu.msu.cme.rdp.classifier.Classifier;
import edu.msu.cme.rdp.classifier.GenusWordConditionalProb;
import edu.msu.cme.rdp.classifier.HierarchyTree;
import edu.msu.cme.rdp.classifier.TrainingDataException;
import edu.msu.cme.rdp.classifier.io.GenusWordProbFileParser;
import edu.msu.cme.rdp.classifier.io.LogWordPriorFileParser;
import edu.msu.cme.rdp.classifier.io.ProbIndexFileParser;
import edu.msu.cme.rdp.classifier.io.TreeFileParser;
import edu.msu.cme.rdp.classifier.utils.ClassifierSequence;
import edu.msu.cme.rdp.classifier.utils.HierarchyVersion;
import edu.msu.cme.rdp.readseq.utils.orientation.GoodWordIterator;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class TrainingInfo {
    private List<HierarchyTree> genusNodeList = new ArrayList<HierarchyTree>();
    private List<GenusWordConditionalProb> genus_wordConditionalProbList = new ArrayList<GenusWordConditionalProb>();
    private static int NUM_OF_WORDS = 65536;
    private int[] wordConditionalProbIndexArr = new int[NUM_OF_WORDS + 1];
    private float[] logLeaveCountArr;
    private HierarchyTree rootTree;
    private String trainRank = "genus";
    private float[] logWordPriorArr = new float[NUM_OF_WORDS];
    private float[] wordPairPriorDiffArr = new float[NUM_OF_WORDS];
    private boolean isTreeDone = false;
    private boolean isWordPriorArrDone = false;
    private boolean isProbIndexArrDone = false;
    private boolean isGenusWordProbListDone = false;
    private HierarchyVersion hierarchyVersion;

    public void createTree(Reader reader) throws IOException, TrainingDataException {
        if (!(this.isProbIndexArrDone || this.isGenusWordProbListDone || this.isWordPriorArrDone)) {
            throw new IllegalStateException("Error: The bergeyTree file should be read after at least one of the other training files");
        }
        TreeFileParser parser = new TreeFileParser();
        this.rootTree = parser.createTree(reader, this.hierarchyVersion);
        this.createGenusNodeList(this.rootTree);
        this.logLeaveCountArr = new float[this.genusNodeList.size()];
        for (HierarchyTree node : this.genusNodeList) {
            this.logLeaveCountArr[node.getGenusIndex()] = (float)Math.log(node.getLeaveCount() + 1);
        }
        this.trainRank = parser.getTrainRank();
        this.isTreeDone = true;
    }

    public void createLogWordPriorArr(Reader reader) throws IOException, TrainingDataException {
        this.hierarchyVersion = LogWordPriorFileParser.createLogWordPriorArr(reader, this.logWordPriorArr, this.hierarchyVersion);
        this.isWordPriorArrDone = true;
        int[] origWord = new int[8];
        this.generateWordPairDiffArr(origWord, 0);
    }

    public void generateWordPairDiffArr(int[] word, int beginIndex) {
        if (beginIndex < 0 || beginIndex > word.length) {
            return;
        }
        int origWordIndex = GoodWordIterator.getWordIndex((int[])word);
        int revWordIndex = GoodWordIterator.getWordIndex((int[])GoodWordIterator.getReversedWord((int[])word));
        float origWordPrior = this.getLogWordPrior(origWordIndex);
        float revWordPrior = this.getLogWordPrior(revWordIndex);
        this.wordPairPriorDiffArr[origWordIndex] = origWordPrior - revWordPrior;
        for (int i = beginIndex; i < word.length; ++i) {
            int origBase = word[i];
            for (int j = 0; j < 4; ++j) {
                if (word[i] == j) continue;
                word[i] = j;
                this.generateWordPairDiffArr(word, i + 1);
                word[i] = origBase;
            }
        }
    }

    public void createGenusWordProbList(Reader reader) throws IOException, TrainingDataException {
        this.hierarchyVersion = GenusWordProbFileParser.createGenusWordProbList(reader, this.genus_wordConditionalProbList, this.hierarchyVersion);
        this.isGenusWordProbListDone = true;
    }

    public void createProbIndexArr(Reader reader) throws IOException, TrainingDataException {
        this.hierarchyVersion = ProbIndexFileParser.createProbIndexArr(reader, this.wordConditionalProbIndexArr, this.hierarchyVersion);
        this.isProbIndexArrDone = true;
    }

    public Classifier createClassifier() {
        if (this.isTreeDone && this.isProbIndexArrDone && this.isGenusWordProbListDone && this.isWordPriorArrDone) {
            Classifier aClassifier = new Classifier(this);
            return aClassifier;
        }
        throw new IllegalStateException("Error: Can not create a Classifier! Training information have not been created.\n ");
    }

    public HierarchyTree getRootTree() {
        return this.rootTree;
    }

    public String getTrainRank() {
        return this.trainRank;
    }

    public int getGenusNodeListSize() {
        return this.genusNodeList.size();
    }

    public HierarchyTree getGenusNodebyIndex(int i) {
        return this.genusNodeList.get(i);
    }

    public float getLogWordPrior(int wordIndex) {
        return this.logWordPriorArr[wordIndex];
    }

    public float getWordPairPriorDiff(int wordIndex) {
        return this.wordPairPriorDiffArr[wordIndex];
    }

    public float getLogLeaveCount(int i) {
        return this.logLeaveCountArr[i];
    }

    public int getStartIndex(int wordIndex) {
        return this.wordConditionalProbIndexArr[wordIndex];
    }

    public int getStopIndex(int wordIndex) {
        return this.wordConditionalProbIndexArr[wordIndex + 1];
    }

    public GenusWordConditionalProb getWordConditionalProbObject(int posIndex) {
        return this.genus_wordConditionalProbList.get(posIndex);
    }

    public String getHierarchyVersion() {
        return this.hierarchyVersion.getVersion();
    }

    public HierarchyVersion getHierarchyInfo() {
        return this.hierarchyVersion;
    }

    private void createGenusNodeList(HierarchyTree root) {
        if (root == null) {
            return;
        }
        int genusIndex = root.getGenusIndex();
        if (genusIndex != -1) {
            this.genusNodeList.add(genusIndex, root);
            return;
        }
        List<Object> al = new ArrayList();
        al = root.getSubclasses();
        if (al.isEmpty()) {
            return;
        }
        for (HierarchyTree hierarchyTree : al) {
            this.createGenusNodeList(hierarchyTree);
        }
    }

    public boolean isSeqReversed(ClassifierSequence seq) throws IOException {
        int[] wordIndexArr = seq.getWordIndexArr();
        boolean reverse = false;
        float priorDiff = 0.0f;
        for (int offset = 0; offset < wordIndexArr.length; ++offset) {
            int wordIndex = wordIndexArr[offset];
            if (wordIndex < 0) continue;
            priorDiff += this.getWordPairPriorDiff(wordIndex);
        }
        if (priorDiff < 0.0f) {
            reverse = true;
        }
        return reverse;
    }

    public boolean isSeqReversed(int[] wordIndexArr, int wordCount) {
        boolean reverse = false;
        float priorDiff = 0.0f;
        for (int offset = 0; offset < wordCount; ++offset) {
            int wordIndex = wordIndexArr[offset];
            if (wordIndex < 0) continue;
            priorDiff += this.getWordPairPriorDiff(wordIndex);
        }
        if (priorDiff < 0.0f) {
            reverse = true;
        }
        return reverse;
    }
}

