/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers.core;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.core.SeqReaderCore;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class STKCore
extends SeqReaderCore {
    private Map<String, List<Long>> seqIndex = new LinkedHashMap<String, List<Long>>();
    private Map<String, Long> seqDescIndex = new LinkedHashMap<String, Long>();
    private List<String> seqids;

    public STKCore(File f) throws IOException {
        super(f);
        RandomAccessFile seqFile = super.getRawFile();
        long firstSeqStart = -1L;
        while (seqFile.getFilePointer() != seqFile.length()) {
            String seqid;
            long currSeqIndex = seqFile.getFilePointer();
            String lineStr = seqFile.readLine().trim();
            char[] line = lineStr.toCharArray();
            if (line.length == 0) continue;
            if (line.length == 2 && line[0] == '/' && line[1] == '/') break;
            if (line[0] == '#') {
                if (line[1] != '=') continue;
                if (line.length < 5) {
                    throw new IOException("Malformed line " + lineStr);
                }
                char metaSeqType = line[3];
                if (line[2] != 'G' || metaSeqType != 'S' && metaSeqType != 'R' && metaSeqType != 'C') {
                    System.err.println("Unknown metasequence type " + lineStr.split("\\s+")[0] + ", not indexing");
                    continue;
                }
                if (line[4] != ' ') {
                    throw new IOException("Malformed line " + lineStr);
                }
                StringBuilder sid = new StringBuilder();
                for (int index = 5; index < line.length && line[index] != ' '; ++index) {
                    sid.append(line[index]);
                }
                if (metaSeqType == 'S') {
                    this.seqDescIndex.put(sid.toString(), currSeqIndex);
                    continue;
                }
                if (metaSeqType != 'C') continue;
                seqid = "#=GC " + sid.toString();
            } else {
                StringBuilder sid = new StringBuilder();
                for (int index = 0; index < line.length && line[index] != ' '; ++index) {
                    sid.append(line[index]);
                }
                seqid = sid.toString();
            }
            if (firstSeqStart == -1L) {
                firstSeqStart = currSeqIndex;
            }
            if (!this.seqIndex.containsKey(seqid)) {
                this.seqIndex.put(seqid, new ArrayList());
            }
            this.seqIndex.get(seqid).add(currSeqIndex);
        }
        seqFile.seek(firstSeqStart);
        this.seqids = new ArrayList<String>(this.seqIndex.keySet());
    }

    public LinkedHashMap<String, Long> scanInternal() throws IOException {
        LinkedHashMap<String, Long> ret = new LinkedHashMap<String, Long>();
        for (String key : this.seqIndex.keySet()) {
            ret.put(key, this.seqIndex.get(key).get(0));
        }
        return ret;
    }

    @Override
    public Sequence readNextSeq() throws IOException {
        RandomAccessFile seqFile = super.getRawFile();
        long seqStart = seqFile.getFilePointer();
        String line = seqFile.readLine().trim();
        while (line.equals("")) {
            if (seqFile.getFilePointer() == seqFile.length()) {
                return null;
            }
            seqStart = seqFile.getFilePointer();
            line = seqFile.readLine().trim();
        }
        if (line.equals("//")) {
            return null;
        }
        String seqid = line.substring(0, line.lastIndexOf(" ")).trim();
        if (this.seqIndex.get(seqid).get(0) != seqStart) {
            return null;
        }
        StringBuilder bases = new StringBuilder();
        if (!this.seqIndex.containsKey(seqid)) {
            throw new IOException("Huh, that's odd, this sequence(" + seqid + ") didn't get indexed...");
        }
        int nextSeqIndex = this.seqids.indexOf(seqid) + 1;
        long seekBackTo = nextSeqIndex == this.seqids.size() ? seqFile.getFilePointer() : this.seqIndex.get(this.seqids.get(nextSeqIndex)).get(0).longValue();
        for (long loc : this.seqIndex.get(seqid)) {
            seqFile.seek(loc);
            line = seqFile.readLine().trim();
            bases.append(line.substring(line.lastIndexOf(" ") + 1).trim());
        }
        String desc = "";
        if (this.seqDescIndex.containsKey(seqid)) {
            seqFile.seek(this.seqDescIndex.get(seqid));
            String[] lexemes = seqFile.readLine().split("\\s+");
            if (!lexemes[0].equals("#=GS")) {
                throw new IOException("Sequence description index error!");
            }
            if (!lexemes[1].equals(seqid)) {
                throw new IOException("I expected to find the description for " + seqid + " but I found the description for " + lexemes[1]);
            }
            for (int index = 3; index < lexemes.length; ++index) {
                desc = desc + lexemes[index] + " ";
            }
            desc = desc.trim();
        }
        seqFile.seek(seekBackTo);
        return new Sequence(seqid, desc, bases.toString());
    }
}

