## ----echo = FALSE-------------------------------------------------------------
library(knitr)

## -----------------------------------------------------------------------------
# Running slinghsot
suppressPackageStartupMessages(library(slingshot))
data("slingshotExample")
rd <- slingshotExample$rd
colnames(rd) <- c("Dim1", "Dim2")
cl <- slingshotExample$cl
df <- data.frame(rd, "cl" = as.character(cl))
sds <- slingshot(rd, cl)

## -----------------------------------------------------------------------------
suppressPackageStartupMessages(library(ggplot2))
suppressPackageStartupMessages(library(dplyr))
# Plotting the results
p <- ggplot(df, aes(x = Dim1, y = Dim2)) +
  geom_point(aes(fill = cl), col = "grey70", shape = 21) + 
  theme_classic()
p

## -----------------------------------------------------------------------------
curves <- slingCurves(sds, as.df = TRUE)
p + geom_path(data = curves %>% arrange(Order),
              aes(group = Lineage)) 

## -----------------------------------------------------------------------------
p + geom_path(data = curves %>% arrange(Order),
              aes(group = Lineage), size = 1.5) 

## -----------------------------------------------------------------------------
p + geom_path(data = curves %>% arrange(Order),
              aes(group = Lineage, col = as.character(Lineage)), size = 1.5) 

## -----------------------------------------------------------------------------
mst <- slingMST(sds, as.df = TRUE)

## -----------------------------------------------------------------------------
p + geom_point(data = mst, size = 4)

## -----------------------------------------------------------------------------
p + geom_point(data = mst, size = 4) +
  geom_path(data = mst %>% arrange(Order), aes(group = Lineage), size = 2)

## -----------------------------------------------------------------------------
suppressPackageStartupMessages(library(scater))
suppressPackageStartupMessages(library(SingleCellExperiment))
sce <- SingleCellExperiment(assays = list(counts = t(rd)),
                            colData = df)
reducedDim(sce, "Dim") <- rd
p <- plotReducedDim(sce, dimred = "Dim", colour_by = "cl")
p

## -----------------------------------------------------------------------------
curves <- slingCurves(sds, as.df = TRUE) %>%
  dplyr::rename("X" = "Dim1", "Y" = "Dim2")
p + geom_path(data = curves %>% arrange(Order),
              aes(group = Lineage)) 

## -----------------------------------------------------------------------------
mst <- slingMST(sds, as.df = TRUE) %>%
  dplyr::rename("X" = "Dim1", "Y" = "Dim2")
p + geom_point(data = mst, size = 4) +
  geom_path(data = mst %>% arrange(Order), aes(group = Lineage), size = 2)

## -----------------------------------------------------------------------------
sessionInfo()

