/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.GlsRecord;

public class GlsRecordNameRef
extends GlsRecord {
    private String title;
    private String href;
    private String hcounter;

    public GlsRecordNameRef(Bib2Gls bib2Gls, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        super(bib2Gls, string, string2, string3, string4, string5);
        this.title = string6;
        this.href = string7;
        this.hcounter = string8;
    }

    protected GlsRecordNameRef(Bib2Gls bib2Gls, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, long l) {
        super(bib2Gls, string, string2, string3, string4, string5, l);
        this.title = string6;
        this.href = string7;
        this.hcounter = string8;
    }

    @Override
    public GlsRecord copy(String string) {
        return new GlsRecordNameRef(this.bib2gls, string, this.getPrefix(), this.getCounter(), this.getFormat(), this.getLocation(), this.title, this.href, this.hcounter, this.getIndex());
    }

    @Override
    public Object clone() {
        return new GlsRecordNameRef(this.bib2gls, this.getLabel(), this.getPrefix(), this.getCounter(), this.getFormat(), this.getLocation(), this.title, this.href, this.hcounter, this.getIndex());
    }

    public String getTitle() {
        return this.title;
    }

    public String getHref() {
        return this.href;
    }

    public String getHcounter() {
        return this.hcounter;
    }

    @Override
    public void merge(String string, GlsRecord glsRecord) {
        super.merge(string, glsRecord);
        if (glsRecord instanceof GlsRecordNameRef) {
            GlsRecordNameRef glsRecordNameRef = (GlsRecordNameRef)glsRecord;
            this.title = glsRecordNameRef.title;
            this.href = glsRecordNameRef.href;
            this.hcounter = glsRecordNameRef.hcounter;
        }
    }

    @Override
    public String getFmtTeXCode(String string) {
        String string2 = this.getFormat();
        if (string2.isEmpty()) {
            string2 = "glsnumberformat";
        } else if (string2.startsWith("(") || string2.startsWith(")")) {
            string2 = string2.length() == 1 ? "glsnumberformat" : string2.substring(1);
        }
        return String.format("\\glsxtrdisplaylocnameref{%s}{%s}{%s}{%s}{%s}{%s}{%s}{}", this.getPrefix(), this.getCounter(), string2, string, this.getTitle(), this.getHref(), this.getHcounter());
    }

    @Override
    public boolean locationMatch(GlsRecord glsRecord) {
        if (this.bib2gls.mergeNameRefOnLocation() || this.bib2gls.mergeWrGlossaryLocations() && this.getCounter().equals("wrglossary")) {
            return super.locationMatch(glsRecord);
        }
        if (!(glsRecord instanceof GlsRecordNameRef)) {
            return false;
        }
        if (!this.getCounter().equals(glsRecord.getCounter())) {
            return false;
        }
        GlsRecordNameRef glsRecordNameRef = (GlsRecordNameRef)glsRecord;
        if (this.bib2gls.mergeNameRefOnTitle()) {
            return this.title.equals(glsRecordNameRef.title);
        }
        return this.href.equals(glsRecordNameRef.href);
    }

    @Override
    public boolean equals(Object object) {
        if (this.bib2gls.mergeWrGlossaryLocations() && this.getCounter().equals("wrglossary")) {
            return super.equals(object);
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof GlsRecordNameRef)) {
            return false;
        }
        GlsRecordNameRef glsRecordNameRef = (GlsRecordNameRef)object;
        return this.href.equals(glsRecordNameRef.href) && this.title.equals(glsRecordNameRef.title) && this.hcounter.equals(glsRecordNameRef.hcounter);
    }

    @Override
    public boolean partialMatch(GlsRecord glsRecord) {
        if (this.bib2gls.mergeNameRefOnLocation() || this.bib2gls.mergeWrGlossaryLocations() && this.getCounter().equals("wrglossary") || !(glsRecord instanceof GlsRecordNameRef)) {
            return super.partialMatch(glsRecord);
        }
        if (!this.getLabel().equals(glsRecord.getLabel())) {
            return false;
        }
        if (!this.getCounter().equals(glsRecord.getCounter())) {
            return false;
        }
        if (this.bib2gls.mergeNameRefOnHcounter()) {
            return this.hcounter.equals(((GlsRecordNameRef)glsRecord).hcounter);
        }
        if (this.bib2gls.mergeNameRefOnTitle()) {
            return this.title.equals(((GlsRecordNameRef)glsRecord).title);
        }
        return this.href.equals(((GlsRecordNameRef)glsRecord).href);
    }

    @Override
    public void shiftEndZeroSection() {
        if (this.hcounter.endsWith(".0")) {
            int n = -1;
            for (int i = 0; i < SECTIONS.length; ++i) {
                if (!this.counter.equals(SECTIONS[i])) continue;
                n = i;
                break;
            }
            if (n > 0) {
                String string = this.hcounter.substring(0, this.hcounter.length() - 2);
                String string2 = SECTIONS[n - 1];
                this.bib2gls.verboseMessage("message.shifting_zero_section", new Object[]{this.counter, this.hcounter, string2, string});
                this.hcounter = string;
                this.counter = string2;
                if (this.location.endsWith(".0")) {
                    this.location = this.location.substring(0, this.location.length() - 2);
                }
                if (n > 1) {
                    this.shiftEndZeroSection();
                }
            }
        }
    }

    @Override
    public String toString() {
        return String.format("{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}{}", this.getLabel(), this.getPrefix(), this.getCounter(), this.getFormat(), this.getLocation(), this.getTitle(), this.getHref(), this.getHcounter());
    }
}

