/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class NumberCs
extends Primitive
implements Expandable {
    public NumberCs() {
        this("number");
    }

    public NumberCs(String string) {
        super(string, true);
    }

    @Override
    public Object clone() {
        return new NumberCs(this.getName());
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        TeXObjectList teXObjectList2 = new TeXObjectList();
        teXObjectList2.add(new UserNumber(numerical.number(teXParser)));
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        Numerical numerical = teXParser.popNumerical();
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(new UserNumber(numerical.number(teXParser)));
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        return teXParser.getListener().createString(String.format("%d", numerical.number(teXParser)));
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        Numerical numerical = teXParser.popNumerical();
        return teXParser.getListener().createString(String.format("%d", numerical.number(teXParser)));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        teXParser.getListener().getWriteable().write(String.format("%d", numerical.number(teXParser)));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        Numerical numerical = teXParser.popNumerical();
        teXParser.getListener().getWriteable().write(String.format("%d", numerical.number(teXParser)));
    }
}

