
function ConvFromByte(var sp : string; flempty : boolean) : byte;
var ptrV : ptrVarRecord;
var s, ss, sh : string;
    i, ii     : integer;
    i1, i2    : integer;
    id, ival  : integer;
    flnoerr   : boolean;
    flwrk, fl : boolean;
    fmin      : byte;
procedure FixError(sh : string);
begin
     ErrorLog('*** Error: Conversion to byte from "'+sp+'" : ');
     ErrorLog('           '+sh);
     if FlagProcessFile then LogReadState; FlagError:=true;
end; {FixError}

const MaxNumb = 255;
begin

     ival:=0;
     s:=sp; sh:=GetFragmString(s);

     flwrk:=false; fl:=true; fmin:=0; ss:='unknown type '+sh;
     if (ord(sh[0]) = 2) and (sh[2] = '@') then
     begin
          flwrk:=true; sh[0]:=chr(1);
     end;
     case ord(sh[0]) of
     0 : begin
              ss:='empty string'; fl:=false;
         end;
     1 : fl:=sh[1] in ['C','c','F','f','V','v',
                       'B','b','D','d','O','o','H','h'];
     2 : if sh[1] in ['V','v'] then
         begin
             case  sh[2] of
             '-' : begin fl:=true; fmin:=1; sh:='V'; end;
             '+' : begin fl:=true; fmin:=0; sh:='V'; end;
             '~' : begin fl:=true; fmin:=2; sh:='V'; end;
             else  begin
                   fl:=false;
             end;
             end; {case}
         end
         else if sh[2] in ['A','a'] then
         begin
             fl:= (sh[1] in ['-','+','~']);
         end
         else fl:=(sh[1] in ['A','a']) and
                  (sh[2] in ['+','-','*','/','%','!','&','^','>','<']);
     else fl:=false;
     end; {case}

     if not fl then
     begin
          FixError(ss);
          ss:=GetFragmString(s);
     end
     else
     if ord(sh[0]) = 1 then
     begin
          if flwrk then ss:=ConvFromString(s,false)
                   else ss:=GetFragmString(s);
          if not (sh[1] in ['V', 'v']) then
          begin
               if (ord(ss[0]) > 0) and (ss[1] = '-') then
               begin
                    fmin:=1;
                    delete(ss,1,1);
               end;
          end;
          ii:=ord(ss[0]);

          case sh[1] of
          'V', 'v' : begin
               ptrV:=ptrVariableGlb; fl:=true;
               FixVarName(ss);
               while (ptrV <> nil) and fl do
               begin
                    if (ptrV^.VType <> VarNone) and (ptrV^.VName = ss) then
                    begin
                         fl:=false;
                         if ptrV^.VType <> VarChar then
                         begin
                            FixError('Illegal variable type ('+ss+')');
                            ival:=0;
                         end
                         else ival:=ptrV^.cval;
                    end;
                    if fl then ptrV:=ptrV^.ptrNext;
               end; {while}
               if fl then
               begin
                  FixError('Unknown variable name ('+ss+')');
                  ival:=0;
               end;
          end;
          'C', 'c' : begin
               if ii <> 1 then FixError('No char ('+ss+')')
                          else ival:=ord(ss[1]);
          end;
          'F', 'f' : begin
                    ss:=UpCaseString(ss);
                    for i:=0 to 17 do
                    begin
                        if ss = FaceName[i] then
                        begin
                             ival:=i; fl:=false;
                        end;
                    end;
                    if fl then
                    begin
                         FixError('No face code ('+ss+')');
                         ival:=0;
                    end;
          end;
          'B', 'b' : begin
                     ival:=0; flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0; '1' : id:=1;
                           else begin
                                if flnoerr then
                                   FixError('Not binary digit ('+ss+')');
                                id:=0; flnoerr:=false;
                           end;
                           end; {case}

                           if (MaxNumb - id) div 2 < ival then
                           begin
                                if flnoerr then
                                   FixError('Too big byte number (B '+ss+')');
                                flnoerr:=false;
                           end
                           else ival:=2*ival+id;

                     end; {for}
               end;
          'O', 'o' : begin
                     ival:=0; flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0; '1' : id:=1; '2' : id:=2;
                           '3' : id:=3; '4' : id:=4; '5' : id:=5;
                           '6' : id:=6; '7' : id:=7;
                           else begin
                                if flnoerr then
                                   FixError('Not octal digit ('+ss+')');
                                id:=0; flnoerr:=false;
                           end;
                           end; {case}

                           if (MaxNumb - id) div 8 < ival then
                           begin
                                if flnoerr then
                                   FixError('Too big byte number (O '+ss+')');
                                flnoerr:=false;
                           end
                           else ival:=8*ival+id;

                     end; {for}
               end;
          'D', 'd' : begin
                     ival:=0; flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0; '1' : id:=1; '2' : id:=2;
                           '3' : id:=3; '4' : id:=4; '5' : id:=5;
                           '6' : id:=6; '7' : id:=7; '8' : id:=8;
                           '9' : id:=9;
                           else begin
                                if flnoerr then
                                   FixError('Not decimal digit ('+ss+')');
                                id:=0; flnoerr:=false;
                           end;
                           end; {case}

                           if (MaxNumb - id) div 10 < ival then
                           begin
                                if flnoerr then
                                   FixError('Too big byte number (D '+ss+')');
                                flnoerr:=false;
                           end
                           else ival:=10*ival+id;

                     end; {for}
               end;
          'H', 'h' : begin
                     ival:=0; flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0; '1' : id:=1; '2' : id:=2;
                           '3' : id:=3; '4' : id:=4; '5' : id:=5;
                           '6' : id:=6; '7' : id:=7; '8' : id:=8;
                           '9' : id:=9;
                           'A','a' : id:=10; 'B','b' : id:=11;
                           'C','c' : id:=12; 'D','d' : id:=13;
                           'E','e' : id:=14; 'F','f' : id:=15;
                           else begin
                                if flnoerr then
                                   FixError ('Not hex digit ('+ss+')');
                                id:=0; flnoerr:=false;
                           end;
                           end; {case}

                           if (MaxNumb - id) div 10 < ival then
                           begin
                                if flnoerr then
                                   FixError('too big byte number (H '+ss+')');
                                flnoerr:=false;
                           end
                           else ival:=16*ival+id;

                     end; {for}
               end;
          else FixError('??? unknown state 1');
          end; {case}
          case fmin of
          0 : ;
          1 : ival:=-ival;
          2 : ival:=ival xor ival;
          end; {case}
     end
     else
     if ord(sh[0]) = 2 then
     begin
        if sh[2] in ['A','a'] then
        begin
             i1:=ConvFromByte(s,false);
             case sh[1] of
             '-' : ival:=-i1;
             '+' : ival:=+i1;
             '~' : ival:=i1 xor i1;
             else begin
                  FixError('??? unknown state 2');
                  ival:=0;
             end;
             end; {case}
        end
        else begin
             i1:=ConvFromByte(s,false);
             i2:=ConvFromByte(s,false);

             case sh[2] of
             '+' : ival:=i1+i2;
             '-' : ival:=i1-i2;
             '*' : ival:=i1*i2;
             '/' : if i2 <> 0 then ival:=i1 div i2
                   else begin
                        FixError('Division by zero (div)');
                        ival:=0;
                   end;
             '%' : if i2 <> 0 then ival:=i1 mod i2
                   else begin
                        FixError('Division by zero (mod)');
                        ival:=0;
                   end;
             '!' : ival:=i1 or i2;
             '&' : ival:=i1 and i2;
             '^' : ival:=i1 xor i2;
             '>' : ival:=i1 shr i2;
             '<' : ival:=i1 shl i2;
             else begin
                  FixError('??? unknown state 3');
                  ival:=0;
             end;
             end; {case}
        end;
     end
     else FixError('??? unknown state 4');

     if flempty and (not (ord(s[0]) = 0)) then
     begin
          FixError('The rest of the string is not empty ('+s+')');
     end;

     sp:=s;
     if (ival < 0) or (ival > MaxNumb) then
     begin
          FixError('Result is too big or less than zero ('
                    +ConvInt(ival)+')');
          ival:=0;
     end;
     ConvFromByte:=ival;

end; {ConvFromByte}


function ConvFromLongInt(var sp : string; flempty : boolean) : longint;
var ptrV : ptrVarRecord;
var ss, sh, s : string;
    i, ii     : integer;
    i1, i2    : longint;
    id        : integer;
    idh       : longint;
    jval      : longword;
    flnoerr   : boolean;
    fl, flwrk : boolean;
    fmin      : byte;
procedure FixError(sh : string);
begin
     ErrorLog('*** Error: Conversion to (long)integer from "'+sp+'" : ');
     ErrorLog('           '+sh);
     if FlagProcessFile then LogReadState; FlagError:=true;
end; {FixError}

begin

     jval.jwordhi:=0; jval.jwordlo:=0;
     s:=sp; sh:=GetFragmString(s);

     flwrk:=false; fl:=true; fmin:=0; ss:='unknown type '+sh;
     if (ord(sh[0]) = 2) and (sh[2] = '@') then
     begin
          flwrk:=true; sh[0]:=chr(1);
     end;
     case ord(sh[0]) of
     0 : begin
              ss:='empty string'; fl:=false;
         end;
     1 : fl:=sh[1] in ['C','c','F','f','V','v',
                       'B','b','D','d','O','o','H','h'];
     2 : if sh[1] in ['V','v'] then
         begin
             case  sh[2] of
             '-' : begin fl:=true; fmin:=1; sh:='V'; end;
             '+' : begin fl:=true; fmin:=0; sh:='V'; end;
             '~' : begin fl:=true; fmin:=2; sh:='V'; end;
             else  fl:=false;
             end; {case}
         end
         else if sh[2] in ['A','a'] then
         begin
             fl:= (sh[1] in ['-','+','~']);
         end
         else fl:=(sh[1] in ['A','a']) and
             (sh[2] in ['+','-','*','/','%','!','&','^','>','<','"','~']);
     else fl:=false;
     end; {case}

     if not fl then
     begin
          FixError(ss);
          ss:=GetFragmString(s);
     end
     else
     if ord(sh[0]) = 1 then
     begin
          if flwrk then ss:=ConvFromString(s,false)
                   else ss:=GetFragmString(s);
          if not (sh[1] in ['V', 'v']) then
          begin
               if (ord(ss[0]) > 0) and (ss[1] = '-') then
               begin
                    fmin:=1;
                    delete(ss,1,1);
               end;
          end;
          ii:=ord(ss[0]);

          case sh[1] of
          'V', 'v' : begin
               ptrV:=ptrVariableGlb; fl:=true;
               FixVarName(ss);
               while (ptrV <> nil) and fl do
               begin
                    if (ptrV^.VType <> VarNone) and (ptrV^.VName = ss) then
                    begin
                         fl:=false;
                         case ptrV^.VType of
                         VarChar : jval.jwordlo:=ptrV^.cval;
                         VarInt  : jval.jwordlo:=ptrV^.jval;
                         else begin
                            FixError('Illegal variable type ('+ss+')');
                            jval.jwordlo:=0;
                         end;
                         end; {case}
                    end;
                    if fl then ptrV:=ptrV^.ptrNext;
               end; {while}
               if fl then
               begin
                  FixError('Unknown variable name ('+ss+')');
                  jval.jwordlo:=0;
               end;

          end;
          'C', 'c' : begin
               if ii <> 1 then FixError('No char ('+ss+')')
                          else jval.jwordlo:=ord(ss[1]);
          end;
          'F', 'f' : begin
                    id:=0; fl:=true;
                    ss:=UpCaseString(ss);
                    for i:=0 to 17 do
                    begin
                        if ss = FaceName[i] then
                        begin
                             id:=i; fl:=false;
                        end;
                    end;
                    if fl then
                    begin
                         FixError('No face code ('+ss+')');
                    end
                    else jval.jwordlo:=id;
          end;
          'B', 'b' : begin
                     flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0; '1' : id:=1;
                           else begin
                                if flnoerr then
                                   FixError('Not binary digit ('+ss+')');
                                id:=0; flnoerr:=false;
                           end;
                           end; {case}

                           idh:=2*jval.jwordlo+id;
                           jval.jwordlo:=idh mod MaxWord;
                           idh:=idh div MaxWord;
                           jval.jwordhi:=2*jval.jwordhi+idh;

                           if jval.jwordhi > MaxWord then
                           begin
                                if flnoerr then
                                   FixError('Too big byte number (B '+ss+')');
                                flnoerr:=false;
                           end;

                     end; {for}
               end;
          'O', 'o' : begin
                     flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0; '1' : id:=1; '2' : id:=2;
                           '3' : id:=3; '4' : id:=4; '5' : id:=5;
                           '6' : id:=6; '7' : id:=7;
                           else begin
                                if flnoerr then
                                   FixError('Not octal digit ('+ss+')');
                                id:=0; flnoerr:=false;
                           end;
                           end; {case}

                           idh:=8*jval.jwordlo+id;
                           jval.jwordlo:=idh mod MaxWord;
                           idh:=idh div MaxWord;
                           jval.jwordhi:=8*jval.jwordhi+idh;

                           if jval.jwordhi > MaxWord then
                           begin
                                if flnoerr then
                                   FixError('Too big byte number (O '+ss+')');
                                flnoerr:=false;
                           end;

                     end; {for}
               end;
          'D', 'd' : begin
                     flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0; '1' : id:=1; '2' : id:=2;
                           '3' : id:=3; '4' : id:=4; '5' : id:=5;
                           '6' : id:=6; '7' : id:=7; '8' : id:=8;
                           '9' : id:=9;
                           else begin
                                if flnoerr then
                                   FixError('Not decimal digit ('+ss+')');
                                id:=0; flnoerr:=false;
                           end;
                           end; {case}

                           idh:=10*jval.jwordlo+id;
                           jval.jwordlo:=idh mod MaxWord;
                           idh:=idh div MaxWord;
                           jval.jwordhi:=10*jval.jwordhi+idh;

                           if jval.jwordhi > MaxWord then
                           begin
                                if flnoerr then
                                   FixError('Too big byte number (D '+ss+')');
                                flnoerr:=false;
                           end;

                     end; {for}
               end;
          'H', 'h' : begin
                     flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0; '1' : id:=1; '2' : id:=2;
                           '3' : id:=3; '4' : id:=4; '5' : id:=5;
                           '6' : id:=6; '7' : id:=7; '8' : id:=8;
                           '9' : id:=9;
                           'A','a' : id:=10; 'B','b' : id:=11;
                           'C','c' : id:=12; 'D','d' : id:=13;
                           'E','e' : id:=14; 'F','f' : id:=15;
                           else begin
                                if flnoerr then
                                   FixError ('Not hex digit ('+ss+')');
                                id:=0; flnoerr:=false;
                           end;
                           end; {case}

                           idh:=16*jval.jwordlo+id;
                           jval.jwordlo:=idh mod MaxWord;
                           idh:=idh div MaxWord;
                           jval.jwordhi:=16*jval.jwordhi+idh;

                           if jval.jwordhi > MaxWord then
                           begin
                                if flnoerr then
                                   FixError('Too big byte number (H '+ss+')');
                                flnoerr:=false;
                           end;

                     end; {for}
               end;
          else FixError('??? unknown state 5');
          end; {case}
     end
     else
     if ord(sh[0]) = 2 then
     begin
        if sh[2] in ['A','a'] then
        begin
             i1:=ConvFromLongInt(s,false);
             case sh[1] of
             '-' : jval.jwordlo:=-i1;
             '+' : jval.jwordlo:=+i1;
             '~' : jval.jwordlo:=i1 xor i1;
             else begin
                  FixError('??? unknown state 6');
             end;
             end; {case}
        end
        else begin
             i1:=ConvFromLongInt(s,false);
             i2:=ConvFromLongInt(s,false);

             case sh[2] of
             '+' : jval.jwordlo:=i1+i2;
             '-' : jval.jwordlo:=i1-i2;
             '*' : jval.jwordlo:=i1*i2;  {???}
             '/' : if i2 <> 0 then jval.jwordlo:=i1 div i2
                   else begin
                        FixError('Division by zero (div)');
                        jval.jwordlo:=0;
                   end;
             '%' : if i2 <> 0 then jval.jwordlo:=i1 mod i2
                   else begin
                        FixError('Division by zero (mod)');
                        jval.jwordlo:=0;
                   end;
             '!' : jval.jwordlo:=i1 or i2;
             '&' : jval.jwordlo:=i1 and i2;
             '^' : jval.jwordlo:=i1 xor i2;
             '>' : jval.jwordlo:=i1 shr i2;
             '<' : jval.jwordlo:=i1 shl i2;
             else FixError('??? unknown state 7');
             end; {case}
        end;
     end
     else FixError('??? unknown state 8');

     if flempty and (not (ord(s[0]) = 0)) then
     begin
          FixError('The rest of the string is not empty ('+s+')');
     end;

     if (jval.iwordlo.iwordhi <> 0) or (jval.iwordhi.iwordhi > 3)  then
     begin
           FixError('Integer overfull ('
                    +ConvInt(jval.iwordhi.iwordhi)+'~'
                    +ConvInt(jval.iwordhi.iwordlo)+'~'
                    +ConvInt(jval.iwordlo.iwordhi)+'~'
                    +ConvInt(jval.iwordlo.iwordlo)+'~'
                    +')');
           jval.jwordlo:=0;
     end;

     {
     jval.iwordlo.iwordhi:=jval.iwordhi.iwordlo;
     }
     jval.jwordlo:=jval.jwordlo + Maxword*jval.jwordhi;

     case fmin of
     0 : ;
     1 : jval.jwordlo:=-jval.jwordlo;
     2 : jval.jwordlo:=jval.jwordlo xor jval.jwordlo;
     end; {case}

     sp:=s;
     ConvFromLongInt:=jval.jwordlo;

end; {ConvFromLongInt}


function ConvFromReal(var sp : string; flempty : boolean) : float;
var ptrV : ptrVarRecord;
var ss, sh, s : string;
    i, ii     : integer;
    i1, i2    : float;
    id, ival  : float;
    ifact     : float;
    flz       : boolean;
    flnoerr   : boolean;
    flwrk, fl, fmin  : boolean;
procedure FixError(sh : string);
begin
     ErrorLog('*** Error: Conversion to real from "'+sp+'" : ');
     ErrorLog('           '+sh);
     if FlagProcessFile then LogReadState; FlagError:=true;
end; {FixError}

begin

     ival:=0.0;
     s:=sp; sh:=GetFragmString(s);

     flwrk:=false; fl:=true; fmin:=false; ss:='unknown type '+sh;
     if (ord(sh[0]) = 2) and (sh[2] = '@') then
     begin
          flwrk:=true; sh[0]:=chr(1);
     end;
     case ord(sh[0]) of
     0 : begin
              ss:='empty string'; fl:=false;
         end;
     1 : fl:=sh[1] in ['C','c','F','f','V','v','R','r',
                       'B','b','D','d','O','o','H','h'];
     2 : if sh[1] in ['V','v'] then
         begin
             case  sh[2] of
             '-' : begin fl:=true; fmin:=true;  sh:='V'; end;
             '+' : begin fl:=true; fmin:=false; sh:='V'; end;
             else  fl:=false;
             end; {case}
         end
         else if sh[2] in ['A','a'] then
         begin
             fl:= (sh[1] in ['-','+']);
         end
         else fl:= (sh[1] in ['A','a']) and
                   (sh[2] in ['+','-','*','/','%','!','&','^','>','<','"']);
     else fl:=false;
     end; {case}

     if not fl then
     begin
          FixError(ss);
          ss:=GetFragmString(s);
     end
     else
     if ord(sh[0]) = 1 then
     begin
          if flwrk then ss:=ConvFromString(s,false)
                   else ss:=GetFragmString(s);
          if not (sh[1] in ['V', 'v']) then
          begin
               if (ord(ss[0]) > 0) and (ss[1] = '-') then
               begin
                    fmin:=true;
                    delete(ss,1,1);
               end;
          end;
          ii:=ord(ss[0]);

          case sh[1] of
          'V', 'v' : begin
               ptrV:=ptrVariableGlb; fl:=true;
               FixVarName(ss);
               while (ptrV <> nil) and fl do
               begin
                    if (ptrV^.VType <> VarNone) and (ptrV^.VName = ss) then
                    begin
                         fl:=false;
                         case ptrV^.VType of
                         VarChar : ival:=ptrV^.cval;
                         VarInt  : ival:=ptrV^.jval;
                         VarReal : ival:=ptrV^.rval;
                         else begin
                            FixError('Illegal variable type ('+ss+')');
                            ival:=0.0;
                         end;
                         end; {case}
                    end;
                    if fl then ptrV:=ptrV^.ptrNext;
               end; {while}
               if fl then
               begin
                  FixError('Unknown variable name ('+ss+')');
                  ival:=0.0;
               end;

          end;
          'C', 'c' : begin
               if ii <> 1 then FixError('No char ('+ss+')')
                          else ival:=ord(ss[1]);
          end;
          'F', 'f' : begin
                    ss:=UpCaseString(ss);
                    for i:=0 to 17 do
                    begin
                        if ss = FaceName[i] then
                        begin
                             ival:=i; fl:=false;
                        end;
                    end;
                    if fl then
                    begin
                         FixError('No face code ('+ss+')');
                         ival:=0.0;
                    end;
          end;
          'R', 'r' : begin
                     ival:=0.0; flnoerr:=true;
                     fl:=true;  ifact:=1.0;

                     for i:=1 to ii do
                     begin
                           flz:=true;
                           case ss[i] of
                           '.' : begin
                                 if fl then fl:=false
                                     else FixError('More than one "." ('+ss+')');
                                 flz:=false;
                                 end;
                           '0' : id:=0.0;
                           '1' : id:=1.0;
                           '2' : id:=2.0;
                           '3' : id:=3.0;
                           '4' : id:=4.0;
                           '5' : id:=5.0;
                           '6' : id:=6.0;
                           '7' : id:=7.0;
                           '8' : id:=8.0;
                           '9' : id:=9.0;
                           else begin
                                if flnoerr then
                                   FixError('Not binary digit ('+ss+')');
                                id:=0.0; flnoerr:=false; flz:=false;
                           end;
                           end; {case}

                           if flz then
                           begin
                              if fl then ival:=10.0*ival+id
                              else begin
                                   ifact:=0.1*ifact;
                                   ival:=ival+id*ifact;
                              end;
                           end;

                     end; {for}
               end;
          'B', 'b' : begin
                     ival:=0; flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0.0; '1' : id:=1.0;
                           else begin
                                if flnoerr then
                                   FixError('Not binary digit ('+ss+')');
                                id:=0.0; flnoerr:=false;
                           end;
                           end; {case}

                           ival:=2.0*ival+id;

                     end; {for}
               end;
          'O', 'o' : begin
                     ival:=0.0; flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0.0; '1' : id:=1.0; '2' : id:=2.0;
                           '3' : id:=3.0; '4' : id:=4.0; '5' : id:=5.0;
                           '6' : id:=6.0; '7' : id:=7.0;
                           else begin
                                if flnoerr then
                                   FixError('Not octal digit ('+ss+')');
                                id:=0.0; flnoerr:=false;
                           end;
                           end; {case}

                           ival:=8.0*ival+id;

                     end; {for}
               end;
          'D', 'd' : begin
                     ival:=0.0; flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0.0; '1' : id:=1.0; '2' : id:=2.0;
                           '3' : id:=3.0; '4' : id:=4.0; '5' : id:=5.0;
                           '6' : id:=6.0; '7' : id:=7.0; '8' : id:=8.0;
                           '9' : id:=9.0;
                           else begin
                                if flnoerr then
                                   FixError('Not decimal digit ('+ss+')');
                                id:=0.0; flnoerr:=false;
                           end;
                           end; {case}

                           ival:=10.0*ival+id;

                     end; {for}
               end;
          'H', 'h' : begin
                     ival:=0.0; flnoerr:=true;
                     for i:=1 to ii do
                     begin
                           case ss[i] of
                           '0' : id:=0.0; '1' : id:=1.0; '2' : id:=2.0;
                           '3' : id:=3.0; '4' : id:=4.0; '5' : id:=5.0;
                           '6' : id:=6.0; '7' : id:=7.0; '8' : id:=8.0;
                           '9' : id:=9.0;
                           'A','a' : id:=10.0; 'B','b' : id:=11.0;
                           'C','c' : id:=12.0; 'D','d' : id:=13.0;
                           'E','e' : id:=14.0; 'F','f' : id:=15.0;
                           else begin
                                if flnoerr then
                                   FixError ('Not hex digit ('+ss+')');
                                id:=0.0; flnoerr:=false;
                           end;
                           end; {case}

                           ival:=16.0*ival+id;

                     end; {for}
               end;
          else FixError('??? unknown state 9');
          end; {case}
     end
     else
     if ord(sh[0]) = 2 then
     begin
        if sh[2] in ['A','a'] then
        begin
             i1:=ConvFromReal(s,false);
             case sh[1] of
             '-' : ival:=-i1;
             '+' : ival:=+i1;
             '~' : FixError('Illegal Operation ('+sh+')');
             else begin
                  FixError('??? unknown state A');
             end;
             end; {case}
        end
        else begin
             i1:=ConvFromReal(s,false);
             i2:=ConvFromReal(s,false);

             case sh[2] of
             '+' : ival:=i1+i2;
             '-' : ival:=i1-i2;
             '*' : ival:=i1*i2;
             '/' : if i2 <> 0 then ival:=i1/i2
                   else begin
                        FixError('Division by zero (div)');
                        ival:=0.0;
                   end;
             '%' : if i2 <> 0 then ival:=i1 - int(i1/i2)*i2
                   else begin
                        FixError('Division by zero (mod)');
                        ival:=0.0;
                   end;
             '!', '&', '^',
             '>','<' : FixError('Illegal Operation ('+sh+')');
             else FixError('??? unknown state B');
             end; {case}
        end;
     end
     else FixError('??? unknown state C');

     if fmin then ival:=-ival;

     if flempty and (not (ord(s[0]) = 0)) then
     begin
          FixError('The rest of the string is not empty ('+s+')');
     end;

     sp:=s;
     ConvFromReal:=ival;

end; {ConvFromReal}


function ConvFromString(var sp : string; flempty : boolean) : string;
var ptrV : ptrVarRecord;
var ss, sh, s : string;
    sres      : string;
    s1, s2    : string;
    ival      : longint;
    rval      : float;
    ii, i     : integer;
    flnoerr   : boolean;
    fl        : boolean;
procedure FixError(sh : string);
begin
     ErrorLog('*** Error: Conversion to string from "'+sp+'" : ');
     ErrorLog('           '+sh);
     if FlagProcessFile then LogReadState; FlagError:=true;
end; {FixError}
begin

     s:=sp;
     sh:=GetFragmString(s);

     if (ord(sh[0]) = 0) or (sh[1] <> '@') then
     begin
          sres:=sh;
     end
     else begin
          fl:=true; ss:='unknown type '+sh;
          case ord(sh[0]) of
          0 : begin
                   ss:='empty string'; fl:=false;
          end;
          1 : fl:=true; {sh[1]='@' -> convert from byte}
          2 : fl:=(sh[2] in ['V','v','U','u','L','l',
                             'R','r','D','d','O','o','H','h','B','b',
                             '@','.','+','F','f','P','p']);
          else fl:=false;
          end; {case}

          if not fl then
          begin
               FixError(ss);
               sres:=GetFragmString(s);
          end
          else if ord(sh[0]) = 1 then
          begin
               ss:=GetFragmString(s);
               sres:=chr(ConvFromByte(ss,true));
          end
          else if ord(sh[0]) = 2 then
          begin
               case sh[2] of
               'V','v' : begin
                    ss:=ConvFromString(s,false);

                    ptrV:=ptrVariableGlb; fl:=true; sres:='';
                    FixVarName(ss);
                    while (ptrV <> nil) and fl do
                    begin
                         if (ptrV^.VType <> VarNone)
                            and (ptrV^.VName = ss)
                         then begin
                              fl:=false;
                              case ptrV^.VType of
                              VarChar : sres:=chr(ptrV^.cval);
                              VarStr  : sres:=ptrV^.psval^;
                              else FixError('Illegal variable type ('+ss+')');
                              end; {case}
                         end;
                         if fl then ptrV:=ptrV^.ptrNext;
                    end; {while}
                    if fl then FixError('Unknown variable name ('+ss+')');
               end;
               'R', 'r' : begin {convert real}
                               rval:=ConvFromReal(s,false);
                               sres:=ConvRealTrue(rval);
                               sres:=DelSpaces(sres);
               end;
               'D', 'd' : begin {convert decimal}
                               ival:=ConvFromLongInt(s,false);
                               sres:=ConvDecLongInt(ival);
                               sres:=DelSpaces(sres);
               end;
               'O', 'o' : begin {convert octal}
                               ival:=ConvFromLongInt(s,false);
                               sres:=ConvOctLongInt(ival);
                               sres:=DelSpaces(sres);
               end;
               'H', 'h' : begin {convert hex}
                               ival:=ConvFromLongInt(s,false);
                               sres:=ConvHexLongInt(ival);
                               sres:=DelSpaces(sres);
               end;
               'B', 'b' : begin {convert bit}
                               ival:=ConvFromLongInt(s,false);
                               sres:=ConvBitLongInt(ival);
                               sres:=DelSpaces(sres);
               end;
               'F', 'f' : begin {extract font name}
                               sres:=ConvFromString(s,false);
                               {!!!
                               sres:=UpCaseString(sres);
                               !!!}
                               ii:=ord(sres[0]);

                               i:=1;
                               while (i <= ii) and
                                     (sres[i] in ['A'..'Z','a'..'z'])
                                  do i:=i+1;
                               sres[0]:=chr(i-1);
               end;
               'P', 'p' : begin {extract pt size}
                               sres:=ConvFromString(s,false);
                               {!!!
                               sres:=UpCaseString(sres);
                               !!!}
                               ii:=ord(sres[0]);

                               i:=1;
                               while (i <= ii) and
                                     (sres[i] in ['A'..'Z','a'..'z'])
                                  do i:=i+1;
                               if i > 1 then delete(sres,1,i-1);
               end;
               'U', 'u' : begin
                               sres:=ConvFromString(s,false);
                               sres:=UpCaseString(sres);
               end;
               'L', 'l' : begin
                               sres:=ConvFromString(s,false);
                               ii:=ord(ss[0]);
                               for i:=1 to ii do
                               begin
                                   if sres[i] in ['A'..'Z']
                                      then sres[i]:=chr(ord(sres[i])-ord('A')+ord('a'));
                               end;
               end;
               '+' : begin
                          s1:=ConvFromString(s,false);
                          s2:=ConvFromString(s,false);
                          sres:=s1+s2;
               end;
               '@' : begin
                          ii:=ConvFromByte(s,false);
                          sres:='';
                          for i:=1 to ii do sres:=sres+' ';
               end;
               '.' : begin
                          sres:='';
               end;
               else begin
                    FixError('??? unknown state D');
                    sres:='';
               end;
               end; {case}
          end
          else begin
               FixError('??? unknown state E');
               sres:='';
          end;
     end; {op string}

     if flempty and (not (ord(s[0]) = 0)) then
     begin
          FixError('The rest of the string is not empty ('+s+')');
     end;

     sp:=s;
     ConvFromString:=sres;

end; {ConvFromString}


