# frozen_string_literal: true

class IndexVulnerabilityReadsOnProjectIdAndVulnerabilityId < Gitlab::Database::Migration[2.1]
  INDEX_NAME = 'index_vulnerability_reads_on_project_id_and_vulnerability_id'

  disable_ddl_transaction!

  def up
    add_concurrent_index :vulnerability_reads, [:project_id, :vulnerability_id], name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
