# frozen_string_literal: true

class IndexVulnerabilityReadsForCommonGroupLevelQuery < Gitlab::Database::Migration[2.2]
  INDEX_NAME = 'idx_vulnerability_reads_for_traversal_ids_queries_srt_severity'
  COLUMNS = %i[state report_type severity traversal_ids vulnerability_id].freeze

  disable_ddl_transaction!
  milestone '17.0'

  def up
    add_concurrent_index :vulnerability_reads, COLUMNS, name: INDEX_NAME, where: 'archived = false'
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
