---
stage: Monitor
group: Observability
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Error Tracking

Error Tracking allows developers to discover and view errors generated by their
application. Because error information is surfaced where the code is developed,
this increases efficiency and awareness. Users can choose between
[GitLab Integrated error tracking](integrated_error_tracking.md) and
[Sentry based](sentry_error_tracking.md) backends.

## How error tracking works

For error tracking to work, you need:

- **Your application configured with the Sentry SDK:** when the error happens, Sentry SDK captures information
  about it and sends it over the network to the backend. The backend stores information about all
  errors.
- **Error tracking backend:** the backend can be either GitLab itself or Sentry.
  - To use the GitLab backend, see [GitLab Integrated error tracking](integrated_error_tracking.md).
    Integrated error tracking is available only on GitLab.com.
  - To use Sentry as the backend, see [Sentry based](sentry_error_tracking.md).
    Sentry based error tracking is available for GitLab.com, GitLab Dedicated and Self-managed instances.

Here is a summary of the capabilities for each version:

| Feature | Availability | Data collection | Data storage | Data query |
| ----------- | ----------- | ----------- | ----------- | ----------- |
| [GitLab integrated Error Tracking](integrated_error_tracking.md) | GitLab.com only | with [Sentry SDK](https://github.com/getsentry/sentry?tab=readme-ov-file#official-sentry-sdks) | Data stored on GitLab.com | with GitLab.com only |
| [Sentry-based Error Tracking](sentry_error_tracking.md) | GitLab.com, GitLab Dedicated, Self-managed | with [Sentry SDK](https://github.com/getsentry/sentry?tab=readme-ov-file#official-sentry-sdks) | Data stored on Sentry instance (Cloud Sentry.io or [Self-Hosted Sentry](https://develop.sentry.dev/self-hosted/)) | with GitLab.com or Sentry instance |
