---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Improper Neutralization of CRLF Sequences in HTTP Headers

## Description

By inserting Carriage Return / Line Feed (CRLF) characters, malicious users could potentially inject arbitrary data into HTTP responses. By modifying HTTP responses, attackers could conduct cross-site scripting or cache poisoning attacks against other users of the system.

## Remediation

User input should never be used in constructing HTTP header responses without some form
of validation against newlines. This includes URLs supplied by the user for HTTP redirects.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 113.1 | false | 113 | Active | high |

## Links

- [OWASP](https://owasp.org/www-community/attacks/HTTP_Response_Splitting)
- [CWE](https://cwe.mitre.org/data/definitions/113.html)
