# frozen_string_literal: true

require 'spec_helper'

RSpec.describe Banzai::Filter::HtmlEntityFilter, feature_category: :team_planning do
  include FilterSpecHelper

  let(:unescaped) { 'foo <strike attr="foo">&&amp;&</strike>' }
  let(:escaped) { 'foo &lt;strike attr=&quot;foo&quot;&gt;&amp;&amp;amp;&amp;&lt;/strike&gt;' }

  it 'converts common entities to their HTML-escaped equivalents' do
    output = filter(unescaped)

    expect(output).to eq(escaped)
  end
end
