/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.di.BpmnDiPackage;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.IFeature;

public class ModelEnablements {
    private Hashtable<String, HashSet<String>> classes = new Hashtable();
    private TargetRuntime targetRuntime = null;
    private String id = "";
    private int enableIdAttribute = -1;

    private ModelEnablements() {
    }

    public ModelEnablements(TargetRuntime targetRuntime, String id) {
        this.targetRuntime = targetRuntime;
        this.id = id;
    }

    public void setEnableIdAttribute(boolean enabled) {
        this.enableIdAttribute = enabled ? 1 : 0;
    }

    public boolean getEnableIdAttribute() {
        return this.enableIdAttribute == 1;
    }

    public void setEnabledAll(boolean enabled) {
        if (enabled) {
            this.classes.clear();
            ArrayList<EClass> items = new ArrayList<EClass>();
            for (EClassifier eclassifier : Bpmn2Package.eINSTANCE.getEClassifiers()) {
                if (!(eclassifier instanceof EClass)) continue;
                items.add((EClass)eclassifier);
            }
            this.setEnabled(items, true);
        } else {
            this.classes.clear();
        }
    }

    public void copy(ModelEnablements me) {
        this.classes.clear();
        for (Map.Entry<String, HashSet<String>> entry : me.classes.entrySet()) {
            String className = entry.getKey();
            HashSet features = new HashSet();
            features.addAll(entry.getValue());
            this.classes.put(className, features);
        }
    }

    private void setEnabled(List<EClass> eClasses, boolean enabled) {
        for (EClass c : eClasses) {
            this.setEnabled(c, enabled);
        }
    }

    public void setEnabled(String[] list) {
        this.setEnabledAll(false);
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int i = s.indexOf(".");
            this.setEnabled(s.substring(0, i), s.substring(i + 1), true);
            ++n2;
        }
    }

    public void setEnabled(EClass eClass, boolean enabled) {
        if (this.isValid(eClass)) {
            if (enabled) {
                if (!this.classes.containsKey(eClass.getName())) {
                    this.setEnabled(eClass.getName(), true);
                }
            } else {
                this.setEnabled(eClass.getName(), false);
            }
        }
    }

    private boolean isValid(EClass eClass) {
        if (eClass != null && eClass.getInstanceClass() != EObject.class) {
            EPackage pkg = eClass.getEPackage();
            return pkg == this.targetRuntime.getModelDescriptor().getEPackage() || pkg == Bpmn2Package.eINSTANCE || pkg == BpmnDiPackage.eINSTANCE;
        }
        return false;
    }

    private EClass getEClass(String className) {
        EClassifier eClassifier = ModelDecorator.findEClassifier(this.targetRuntime.getModelDescriptor().getEPackage(), className);
        if (eClassifier instanceof EClass) {
            return (EClass)eClassifier;
        }
        return null;
    }

    private void setEnabledSingle(EClass eClass, boolean enabled) {
        if (this.isValid(eClass)) {
            this.setEnabledSingle(eClass.getName(), enabled);
        }
    }

    private void setEnabledSingle(String className, boolean enabled) {
        if (enabled) {
            if (this.classes.containsKey(className)) {
                return;
            }
            HashSet features = new HashSet();
            this.classes.put(className, features);
        } else {
            if (!this.classes.containsKey(className)) {
                return;
            }
            this.classes.remove(className);
        }
    }

    public void setEnabled(String name, boolean enabled) {
        block8: {
            EClass eClass;
            block7: {
                HashSet<String> features;
                int i = name.indexOf(".");
                if (i > 0) {
                    this.setEnabled(name.substring(0, i), name.substring(i + 1), enabled);
                    return;
                }
                eClass = this.getEClass(name);
                this.setEnabledSingle(name, enabled);
                if (!enabled) break block7;
                if (eClass == null || !(features = this.classes.get(name)).isEmpty()) break block8;
                for (EAttribute a : eClass.getEAllAttributes()) {
                    features.add(a.getName());
                }
                for (EAttribute a : eClass.getEAllContainments()) {
                    features.add(a.getName());
                }
                for (EAttribute a : eClass.getEAllReferences()) {
                    features.add(a.getName());
                }
                break block8;
            }
            ArrayList<String> removed = new ArrayList<String>();
            for (Map.Entry<String, HashSet<String>> entry : this.classes.entrySet()) {
                EClass ec = this.getEClass(entry.getKey());
                if (ec == null) continue;
                HashSet<String> features = entry.getValue();
                for (EReference a : ec.getEAllContainments()) {
                    if (a.getEReferenceType() != eClass) continue;
                    removed.add(a.getName());
                }
                for (EReference a : ec.getEAllReferences()) {
                    if (a.getEReferenceType() != eClass) continue;
                    removed.add(a.getName());
                }
                features.removeAll(removed);
            }
        }
    }

    public void setEnabledAll(EClass eClass, boolean enabled) {
        block7: {
            block6: {
                this.setEnabledSingle(eClass, enabled);
                if (!enabled) break block6;
                if (eClass == null) break block7;
                HashSet<String> features = this.classes.get(eClass.getName());
                for (EAttribute a : eClass.getEAllAttributes()) {
                    features.add(a.getName());
                }
                for (EAttribute a : eClass.getEAllContainments()) {
                    features.add(a.getName());
                    this.setEnabledSingle(a.getEReferenceType(), true);
                }
                for (EAttribute a : eClass.getEAllReferences()) {
                    features.add(a.getName());
                    this.setEnabledSingle(a.getEReferenceType(), true);
                }
                break block7;
            }
            ArrayList<String> removed = new ArrayList<String>();
            for (Map.Entry<String, HashSet<String>> entry : this.classes.entrySet()) {
                EClass ec = this.getEClass(entry.getKey());
                if (ec == null) continue;
                HashSet<String> features = entry.getValue();
                for (EReference a : ec.getEAllContainments()) {
                    if (a.getEReferenceType() != eClass) continue;
                    removed.add(a.getName());
                }
                for (EReference a : ec.getEAllReferences()) {
                    if (a.getEReferenceType() != eClass) continue;
                    removed.add(a.getName());
                }
                features.removeAll(removed);
            }
        }
    }

    public void setEnabled(String className, String featureName, boolean enabled) {
        if ("all".equals(className)) {
            if (featureName == null) {
                this.setEnabledAll(enabled);
            } else {
                for (Map.Entry<String, HashSet<String>> entry : this.classes.entrySet()) {
                    HashSet<String> features = entry.getValue();
                    if (enabled) {
                        features.add(featureName);
                        continue;
                    }
                    features.remove(featureName);
                }
            }
        } else if (featureName != null && !featureName.isEmpty()) {
            if ("all".equals(featureName)) {
                if (enabled) {
                    this.setEnabled(className, true);
                } else if (this.classes.containsKey(className)) {
                    this.classes.get(className).clear();
                }
            } else if (enabled) {
                HashSet<Object> features;
                if (this.classes.containsKey(className)) {
                    features = this.classes.get(className);
                } else {
                    features = new HashSet();
                    this.classes.put(className, features);
                }
                features.add(featureName);
            } else if (this.classes.containsKey(className)) {
                this.classes.get(className).remove(featureName);
            }
        } else {
            this.setEnabled(className, enabled);
        }
    }

    public boolean isEnabled(String className, String featureName) {
        if (this.enableIdAttribute == -1) {
            Bpmn2Preferences prefs = Bpmn2Preferences.getInstance();
            this.setEnableIdAttribute(prefs.getShowIdAttribute());
        }
        if ("id".equals(featureName)) {
            return this.getEnableIdAttribute();
        }
        if (className == null) {
            return true;
        }
        if (this.classes.containsKey(className)) {
            if (featureName != null && !featureName.isEmpty()) {
                if ("anyAttribute".equals(featureName)) {
                    return true;
                }
                HashSet<String> features = this.classes.get(className);
                if (features.contains(featureName) || features.isEmpty()) {
                    return true;
                }
                EClass eClass = this.getEClass(className);
                if (eClass != null) {
                    for (EClass st : eClass.getEAllSuperTypes()) {
                        String cn = st.getName();
                        if (!this.classes.containsKey(cn)) continue;
                        if (featureName != null && !featureName.isEmpty()) {
                            features = this.classes.get(cn);
                            if (!features.contains(featureName)) break;
                            return true;
                        }
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isEnabled(EClass eClass, EStructuralFeature feature) {
        if (feature == null) {
            return this.isEnabled(eClass);
        }
        return this.isEnabled(eClass.getName(), feature.getName());
    }

    public boolean isEnabled(EClass eClass) {
        if (eClass == null) {
            return false;
        }
        EPackage pkg = eClass.getEPackage();
        if (pkg instanceof BpmnDiPackage) {
            return true;
        }
        return this.isEnabled(eClass.getName());
    }

    public boolean isEnabled(String className) {
        int i = className.indexOf(".");
        if (i > 0) {
            return this.isEnabled(className.substring(0, i), className.substring(i + 1));
        }
        return this.isEnabled(className, null);
    }

    public boolean isEnabled(IFeature feature) {
        if (feature instanceof IBpmn2CreateFeature) {
            EClass eClass = ((IBpmn2CreateFeature)feature).getBusinessObjectClass();
            return this.isEnabled(eClass);
        }
        return false;
    }

    public int size() {
        return this.classes.size();
    }

    public List<String> getAllEnabled() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, HashSet<String>> entry : this.classes.entrySet()) {
            String className = entry.getKey();
            list.add(className);
            HashSet<String> features = entry.getValue();
            for (String featureName : features) {
                list.add(String.valueOf(className) + "." + featureName);
            }
        }
        return list;
    }

    public Collection<String> getAllEnabledClasses() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, HashSet<String>> entry : this.classes.entrySet()) {
            String className = entry.getKey();
            list.add(className);
        }
        return list;
    }

    public Collection<String> getAllEnabledFeatures(String className) {
        if (this.classes.containsKey(className)) {
            return this.classes.get(className);
        }
        return new ArrayList<String>();
    }

    public static List<EClass> getSubClasses(EClass parentClass) {
        ArrayList<EClass> classList = new ArrayList<EClass>();
        EList classifiers = Bpmn2Package.eINSTANCE.getEClassifiers();
        for (EClassifier classifier : classifiers) {
            if (!(classifier instanceof EClass)) continue;
            EClass clazz = (EClass)classifier;
            clazz.getEAllSuperTypes().contains((Object)parentClass);
            if (!parentClass.isSuperTypeOf(clazz) || clazz.isAbstract()) continue;
            classList.add(clazz);
        }
        return classList;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

