/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.Platform.dd;

import ee.jakarta.tck.concurrent.common.context.providers.IntContextProvider;
import ee.jakarta.tck.concurrent.common.context.providers.StringContextProvider;
import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Challenge;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Full;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.spec.Platform.dd.DeploymentDescriptorServlet;
import ee.jakarta.tck.concurrent.spec.Platform.dd.DeploymentDescriptorTestBean;
import ee.jakarta.tck.concurrent.spec.Platform.dd.DeploymentDescriptorTestBeanInterface;
import ee.jakarta.tck.concurrent.spec.Platform.dd.ManagedThreadFactoryProducer;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

@Full
@RunAsClient
public class DeploymentDescriptorFullTests
extends TestClient {
    @ArquillianResource(value=DeploymentDescriptorServlet.class)
    private URL baseURL;
    @TestName
    private String testname;

    @Deployment(name="DeploymentDescriptorTests")
    public static EnterpriseArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"DeploymentDescriptorTests_web.war")).addClasses(new Class[]{DeploymentDescriptorServlet.class, ManagedThreadFactoryProducer.class});
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"DeploymentDescriptorTests_ejb.jar")).addClasses(new Class[]{DeploymentDescriptorTestBean.class, DeploymentDescriptorTestBeanInterface.class})).addPackages(false, new String[]{Common.PACKAGE.CONTEXT.getPackageName(), Common.PACKAGE.CONTEXT_PROVIDERS.getPackageName(), Common.PACKAGE.QUALIFIERS.getPackageName()})).addAsServiceProvider(ThreadContextProvider.class.getName(), new String[]{IntContextProvider.class.getName(), StringContextProvider.class.getName()});
        EnterpriseArchive ear = (EnterpriseArchive)((EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"DeploymentDescriptorTests.ear")).addAsManifestResource(DeploymentDescriptorFullTests.class.getPackage(), "application.xml", "application.xml")).addAsModules(new Archive[]{war, jar});
        return ear;
    }

    @Override
    protected String getServletPath() {
        return "DeploymentDescriptorServlet";
    }

    @Assertion(id="GIT:404", strategy="Tests injection of context service defined in a deployment descriptor with qualifier(s).")
    public void testDeploymentDescriptorDefinedContextServiceQualifiers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed executor service defined in a deployment descriptor with qualifier(s).")
    public void testDeploymentDescriptorDefinedManagedExecutorSvcQualifiers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed scheduled exectuor service defined in a deployment descriptor with qualifier(s).")
    public void testDeploymentDescriptorDefinedManagedScheduledExecutorSvcQualifers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed thread factory defined in a deployment descriptor with qualifier(s).")
    public void testDeploymentDescriptorDefinedManagedThreadFactoryQualifers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:186", strategy="Tests context-service defined in a deployment descriptor.")
    public void testDeploymentDescriptorDefinesContextService() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:186", strategy="Tests managed-executor defined in a deployment descriptor.")
    public void testDeploymentDescriptorDefinesManagedExecutor() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:186", strategy="Tests managed-scheduled-executor defined in a deployment descriptor.")
    public void testDeploymentDescriptorDefinesManagedScheduledExecutor() {
        this.runTest(this.baseURL, this.testname);
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/issues/226", version="3.0.0")
    @Assertion(id="GIT:186", strategy="Tests managed-thread-factory defined in a deployment descriptor.")
    public void testDeploymentDescriptorDefinesManagedThreadFactory() {
        this.runTest(this.baseURL, this.testname);
    }
}

