/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.Platform.anno;

import ee.jakarta.tck.concurrent.common.context.providers.IntContextProvider;
import ee.jakarta.tck.concurrent.common.context.providers.StringContextProvider;
import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Challenge;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Full;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.spec.Platform.anno.AnnotationServlet;
import ee.jakarta.tck.concurrent.spec.Platform.anno.AnnotationTestBean;
import ee.jakarta.tck.concurrent.spec.Platform.anno.AnnotationTestBeanInterface;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

@Full
@RunAsClient
public class AnnotationFullTests
extends TestClient {
    @ArquillianResource(value=AnnotationServlet.class)
    private URL baseURL;
    @TestName
    private String testname;

    @Deployment(name="AnnotationTests")
    public static EnterpriseArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"AnnotationTests_web.war")).addClasses(new Class[]{AnnotationServlet.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"AnnotationTests_ejb.jar")).addClasses(new Class[]{AnnotationTestBean.class, AnnotationTestBeanInterface.class})).addPackages(false, new String[]{Common.PACKAGE.CONTEXT.getPackageName(), Common.PACKAGE.CONTEXT_PROVIDERS.getPackageName(), Common.PACKAGE.QUALIFIERS.getPackageName()})).addAsServiceProvider(ThreadContextProvider.class.getName(), new String[]{IntContextProvider.class.getName(), StringContextProvider.class.getName()});
        EnterpriseArchive ear = (EnterpriseArchive)((EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"AnnotationTests.ear")).addAsManifestResource(AnnotationFullTests.class.getPackage(), "application.xml", "application.xml")).addAsModules(new Archive[]{war, jar});
        return ear;
    }

    @Override
    protected String getServletPath() {
        return "AnnotationServlet";
    }

    @Assertion(id="GIT:404", strategy="Tests injection of context service defined in an annotation with qualifier(s).")
    public void testAnnoDefinedContextServiceQualifiers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed executor service defined in an annotation with qualifier(s).")
    public void testAnnoDefinedManagedExecutorSvcQualifiers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed scheduled exectuor service defined in an annotation with qualifier(s).")
    public void testAnnoDefinedManagedScheduledExecutorSvcQualifers() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests injection of managed thread factory defined in an annotation with qualifier(s).")
    public void testAnnoDefinedManagedThreadFactoryQualifersFull() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests context-service defined in a annotation.")
    public void testAnnotationDefinesContextService() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests managed-executor defined in a annotation.")
    public void testAnnotationDefinesManagedExecutor() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:404", strategy="Tests managed-scheduled-executor defined in a annotation.")
    public void testAnnotationDefinesManagedScheduledExecutor() {
        this.runTest(this.baseURL, this.testname);
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/issues/226", version="3.0.0")
    @Assertion(id="GIT:404", strategy="Tests managed-thread-factory defined in a annotation.")
    public void testAnnotationDefinesManagedThreadFactory() {
        this.runTest(this.baseURL, this.testname);
    }
}

