/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model;

import com.sun.webui.jsf.component.WizardStep;
import com.sun.webui.jsf.model.WizardModel;
import com.sun.webui.jsf.model.WizardStepList;
import com.sun.webui.jsf.model.WizardStepListItemBase;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class WizardStepListBase
implements WizardStepList {
    private static final String DOT = ".";
    private static final String SWBRACKET_OPEN = "[";
    private static final String SWBRACKET_CLOSE = "]";
    private final WizardModel wModel;
    private int currentStep;
    private String currentStepNumberString;

    public WizardStepListBase(WizardModel newWModel) {
        this.wModel = newWModel;
        this.iterate();
    }

    @Override
    public String getCurrentStepNumberString() {
        return this.currentStepNumberString;
    }

    protected String formatStepNumber(int stepNumber) {
        return String.valueOf(stepNumber);
    }

    protected String formatSubstepNumber(int stepNumber, int substep) {
        return String.valueOf(stepNumber).concat(DOT).concat(String.valueOf(substep));
    }

    protected String formatBranch(String placeholderText) {
        return SWBRACKET_OPEN.concat(placeholderText).concat(SWBRACKET_CLOSE);
    }

    private void iterate() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private int stepNumber = 0;
            private int substep = 0;
            private String stepNumberString;
            private String placeholderText;
            private boolean isBranch;
            private final Iterator wizardStepIterator = WizardStepListBase.access$000(WizardStepListBase.this).getWizardStepIterator();

            @Override
            public boolean hasNext() {
                return this.wizardStepIterator.hasNext();
            }

            public Object next() throws NoSuchElementException {
                if (this.isBranch) {
                    throw new NoSuchElementException("No more steps after branch");
                }
                try {
                    WizardStep step = (WizardStep)((Object)this.wizardStepIterator.next());
                    boolean isSubstep = WizardStepListBase.this.wModel.isSubstep(step);
                    this.isBranch = WizardStepListBase.this.wModel.isBranch(step);
                    this.placeholderText = null;
                    if (isSubstep) {
                        ++this.substep;
                        this.stepNumberString = WizardStepListBase.this.formatSubstepNumber(this.stepNumber, this.substep);
                    } else if (this.isBranch) {
                        ++this.stepNumber;
                        this.substep = 0;
                        this.stepNumberString = null;
                    } else {
                        ++this.stepNumber;
                        this.substep = 0;
                        this.stepNumberString = WizardStepListBase.this.formatStepNumber(this.stepNumber);
                    }
                    boolean isCurrentStep = WizardStepListBase.this.wModel.isCurrentStep(step);
                    if (isCurrentStep) {
                        WizardStepListBase.this.currentStep = this.stepNumber;
                        WizardStepListBase.this.currentStepNumberString = this.stepNumberString;
                    }
                    return new WizardStepListItemBase(step, this.stepNumberString, isCurrentStep, isSubstep, this.isBranch, this.placeholderText, WizardStepListBase.this.wModel.canGotoStep(step));
                }
                catch (Exception e) {
                    NoSuchElementException nse = new NoSuchElementException();
                    nse.initCause(e);
                    throw nse;
                }
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }
}

