/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Property;
import org.apache.felix.bundlerepository.impl.PropertyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilityImpl
implements Capability {
    private String m_name = null;
    private final Map<String, Object> m_attributes = new HashMap<String, Object>();
    private final Map<String, String> m_directives = new HashMap<String, String>();
    private final List<Property> m_propList = new ArrayList<Property>();

    public CapabilityImpl() {
    }

    public CapabilityImpl(String name) {
        this.setName(name);
    }

    public CapabilityImpl(String name, PropertyImpl[] properties) {
        this.setName(name);
        for (int i = 0; properties != null && i < properties.length; ++i) {
            this.addProperty(properties[i]);
        }
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.intern();
    }

    @Override
    public Map<String, Object> getPropertiesAsMap() {
        return this.m_attributes;
    }

    @Override
    public Property[] getProperties() {
        return this.m_propList.toArray(new Property[this.m_propList.size()]);
    }

    public void addProperty(Property prop) {
        this.m_attributes.put(prop.getName(), prop.getConvertedValue());
        this.m_propList.add(prop);
    }

    public void addProperty(String name, String value) {
        this.addProperty(name, null, value);
    }

    public void addProperty(String name, String type, String value) {
        this.addProperty(new PropertyImpl(name, type, value));
    }

    public String toString() {
        return this.m_name + ":" + this.m_attributes.toString();
    }

    public void addDirective(String key, String value) {
        this.m_directives.put(key, value);
    }

    @Override
    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.m_directives);
    }
}

