/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ViewHandlerResponseWrapper;
import com.sun.faces.application.view.ViewHandlingStrategy;
import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ViewVisitOption;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.view.StateManagementStrategy;
import jakarta.faces.view.ViewMetadata;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.jstl.core.Config;
import java.beans.BeanInfo;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class JspViewHandlingStrategy
extends ViewHandlingStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private int responseBufferSize;

    public JspViewHandlingStrategy() {
        try {
            this.responseBufferSize = Integer.parseInt(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResponseBufferSize));
        }
        catch (NumberFormatException nfe) {
            this.responseBufferSize = Integer.parseInt(WebConfiguration.WebContextInitParameter.ResponseBufferSize.getDefaultValue());
        }
    }

    @Override
    public ViewMetadata getViewMetadata(FacesContext context, String viewId) {
        return null;
    }

    @Override
    public void buildView(FacesContext context, UIViewRoot view) throws IOException {
        if (Util.isViewPopulated(context, view)) {
            return;
        }
        try {
            if (this.executePageToBuildView(context, view)) {
                context.getExternalContext().responseFlushBuffer();
                if (this.associate != null) {
                    this.associate.responseRendered();
                }
                context.responseComplete();
                return;
            }
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Completed building view for : \n" + view.getViewId());
        }
        context.getApplication().publishEvent(context, PostAddToViewEvent.class, UIViewRoot.class, view);
        Util.setViewPopulated(context, view);
    }

    @Override
    public void renderView(FacesContext context, UIViewRoot view) throws IOException {
        ViewHandlerResponseWrapper wrapper;
        WriteBehindStateWriter stateWriter;
        ResponseWriter oldWriter;
        ExternalContext extContext;
        block11: {
            ResponseWriter newWriter;
            block12: {
                if (!view.isRendered() || context.getResponseComplete()) {
                    return;
                }
                extContext = context.getExternalContext();
                if (!Util.isViewPopulated(context, view)) {
                    this.buildView(context, view);
                }
                RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory("jakarta.faces.render.RenderKitFactory");
                RenderKit renderKit = renderFactory.getRenderKit(context, view.getRenderKitId());
                oldWriter = context.getResponseWriter();
                stateWriter = new WriteBehindStateWriter(extContext.getResponseOutputWriter(), context, this.responseBufferSize);
                newWriter = null != oldWriter ? oldWriter.cloneWithWriter(stateWriter) : renderKit.createResponseWriter(stateWriter, null, extContext.getRequestCharacterEncoding());
                context.setResponseWriter(newWriter);
                if (context.getPartialViewContext().isPartialRequest()) {
                    this.doRenderView(context, view);
                    try {
                        extContext.getFlash().doPostPhaseActions(context);
                    }
                    catch (UnsupportedOperationException uoe) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("ExternalContext.getFlash() throw UnsupportedOperationException -> Flash unavailable");
                        }
                        break block11;
                    }
                }
                newWriter.startDocument();
                this.doRenderView(context, view);
                try {
                    extContext.getFlash().doPostPhaseActions(context);
                }
                catch (UnsupportedOperationException uoe) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block12;
                    LOGGER.fine("ExternalContext.getFlash() throw UnsupportedOperationException -> Flash unavailable");
                }
            }
            newWriter.endDocument();
        }
        if (stateWriter.stateWritten()) {
            stateWriter.flushToWriter();
        }
        stateWriter.release();
        if (null != oldWriter) {
            context.setResponseWriter(oldWriter);
        }
        if (null != (wrapper = (ViewHandlerResponseWrapper)((Object)RequestStateManager.remove(context, "com.sun.faces.AFTER_VIEW_CONTENT")))) {
            wrapper.flushToWriter(extContext.getResponseOutputWriter(), extContext.getResponseCharacterEncoding());
        }
        extContext.responseFlushBuffer();
    }

    @Override
    public StateManagementStrategy getStateManagementStrategy(FacesContext context, String viewId) {
        return null;
    }

    @Override
    public BeanInfo getComponentMetadata(FacesContext context, Resource componentResource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource getScriptComponentResource(FacesContext context, Resource componentResource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<String> getViews(FacesContext context, String path, ViewVisitOption ... options) {
        return Stream.empty();
    }

    @Override
    public Stream<String> getViews(FacesContext context, String path, int maxDepth, ViewVisitOption ... options) {
        return Stream.empty();
    }

    @Override
    public boolean handlesViewId(String viewId) {
        return true;
    }

    @Override
    public String getId() {
        return "java.faces.JSP";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executePageToBuildView(FacesContext context, UIViewRoot viewToExecute) throws IOException {
        if (null == context) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        if (null == viewToExecute) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "viewToExecute");
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        if ("/*".equals(RequestStateManager.get(context, "com.sun.faces.INVOCATION_PATH"))) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.FACES_SERVLET_MAPPING_INCORRECT", new Object[0]));
        }
        String requestURI = viewToExecute.getViewId();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to execute view " + requestURI);
        }
        if (extContext.getRequest() instanceof ServletRequest) {
            Config.set((ServletRequest)((ServletRequest)extContext.getRequest()), (String)"jakarta.servlet.jsp.jstl.fmt.locale", (Object)context.getViewRoot().getLocale());
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Before dispacthMessage to viewId " + requestURI);
        }
        Object originalResponse = extContext.getResponse();
        ViewHandlerResponseWrapper wrapped = JspViewHandlingStrategy.getWrapper(extContext);
        extContext.setResponse((Object)wrapped);
        try {
            extContext.dispatch(requestURI);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("After dispacthMessage to viewId " + requestURI);
            }
        }
        finally {
            extContext.setResponse(originalResponse);
        }
        if (wrapped.getStatus() < 200 || wrapped.getStatus() > 299) {
            wrapped.flushContentToWrappedResponse();
            return true;
        }
        RequestStateManager.set(context, "com.sun.faces.AFTER_VIEW_CONTENT", (Object)wrapped);
        return false;
    }

    private void doRenderView(FacesContext context, UIViewRoot viewToRender) throws IOException {
        if (null != this.associate) {
            this.associate.responseRendered();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "About to render view " + viewToRender.getViewId());
        }
        viewToRender.encodeAll(context);
    }

    private static ViewHandlerResponseWrapper getWrapper(ExternalContext extContext) {
        Object response = extContext.getResponse();
        if (response instanceof HttpServletResponse) {
            return new ViewHandlerResponseWrapper((HttpServletResponse)response);
        }
        throw new IllegalArgumentException();
    }
}

