/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.taglib.jsf_core;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.component.StateHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;

public class SetPropertyActionListenerImpl
implements ActionListener,
StateHolder {
    private ValueExpression target;
    private ValueExpression source;

    public SetPropertyActionListenerImpl() {
    }

    public SetPropertyActionListenerImpl(ValueExpression target, ValueExpression value) {
        this.target = target;
        this.source = value;
    }

    @Override
    public void processAction(ActionEvent e) throws AbortProcessingException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        try {
            Object value = this.source.getValue(elContext);
            if (value != null) {
                ExpressionFactory factory = facesContext.getApplication().getExpressionFactory();
                value = factory.coerceToType(value, this.target.getType(elContext));
            }
            this.target.setValue(elContext, value);
        }
        catch (ELException ele) {
            throw new AbortProcessingException(ele);
        }
    }

    @Override
    public void setTransient(boolean trans) {
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] state = new Object[]{this.target, this.source};
        return state;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        Object[] stateArray = (Object[])state;
        this.target = (ValueExpression)stateArray[0];
        this.source = (ValueExpression)stateArray[1];
    }
}

