/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.ServerDirs;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;

public class StartServerHelper {
    private static final boolean DEBUG_MESSAGES_ON = false;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartServerHelper.class);
    private final boolean terse;
    private final GFLauncher launcher;
    private final Logger logger;
    private final File pidFile;
    private final GFLauncherInfo info;
    private final List<HostAndPort> addresses;
    private final ServerDirs serverDirs;
    private final String masterPassword;
    private final String serverOrDomainName;
    private final int debugPort;
    private final boolean isDebugSuspend;

    public StartServerHelper(Logger logger, boolean terse, ServerDirs serverDirs, GFLauncher launcher, String masterPassword) {
        this(logger, terse, serverDirs, launcher, masterPassword, false);
    }

    public StartServerHelper(Logger logger, boolean terse, ServerDirs serverDirs, GFLauncher launcher, String masterPassword, boolean debug) {
        this.logger = logger;
        this.terse = terse;
        this.launcher = launcher;
        this.info = launcher.getInfo();
        this.serverOrDomainName = this.info.isDomain() ? this.info.getDomainName() : this.info.getInstanceName();
        this.addresses = this.info.getAdminAddresses();
        this.serverDirs = serverDirs;
        this.pidFile = serverDirs.getPidFile();
        this.masterPassword = masterPassword;
        this.debugPort = launcher.getDebugPort();
        this.isDebugSuspend = launcher.isDebugSuspend();
        if (this.isDebugSuspend && this.debugPort >= 0) {
            logger.info(strings.get("ServerStart.DebuggerSuspendedMessage", new Object[]{"" + this.debugPort}));
        }
    }

    public void waitForServer() throws CommandException {
        long startWait = System.currentTimeMillis();
        if (!this.terse) {
            System.out.print(strings.get("WaitServer", new Object[]{this.serverOrDomainName}) + " ");
        }
        boolean alive = false;
        int count = 0;
        block4: while (!StartServerHelper.timedOut(startWait)) {
            if (this.pidFile != null) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Check for pid file: " + this.pidFile);
                }
                if (this.pidFile.exists()) {
                    alive = true;
                    break;
                }
            } else {
                for (HostAndPort address : this.addresses) {
                    if (!NetUtils.isRunning((String)address.getHost(), (int)address.getPort())) continue;
                    alive = true;
                    break block4;
                }
            }
            try {
                Process glassFishProcess2 = this.launcher.getProcess();
                int exitCode = glassFishProcess2.exitValue();
                String sname = this.info.isDomain() ? "domain " + this.info.getDomainName() : "instance " + this.info.getInstanceName();
                ProcessStreamDrainer psd = this.launcher.getProcessStreamDrainer();
                String output = psd.getOutErrString();
                if (StringUtils.ok((String)output)) {
                    throw new CommandException(strings.get("serverDiedOutput", new Object[]{sname, exitCode, output}));
                }
                throw new CommandException(strings.get("serverDied", new Object[]{sname, exitCode}));
            }
            catch (GFLauncherException | IllegalThreadStateException glassFishProcess2) {
                try {
                    Thread.sleep(100L);
                    if (this.terse || count++ % 10 != 0) continue;
                    System.out.print(".");
                }
                catch (InterruptedException glassFishProcess2) {}
            }
        }
        if (!this.terse) {
            System.out.println();
        }
        if (!alive) {
            String time = "600";
            String msg = this.info.isDomain() ? strings.get("serverNoStart", new Object[]{strings.get("DAS"), this.info.getDomainName(), time}) : strings.get("serverNoStart", new Object[]{strings.get("INSTANCE"), this.info.getInstanceName(), time});
            throw new CommandException(msg);
        }
    }

    public boolean prepareForLaunch() throws CommandException {
        this.waitForParentToDie();
        this.setSecurity();
        if (!this.checkPorts()) {
            return false;
        }
        this.deletePidFile();
        return true;
    }

    public void report() {
        String logfile;
        try {
            logfile = this.launcher.getLogFilename();
        }
        catch (GFLauncherException ex) {
            logfile = "UNKNOWN";
        }
        int adminPort = -1;
        Object adminPortString = "-1";
        try {
            if (this.addresses != null && this.addresses.size() > 0) {
                adminPort = this.addresses.get(0).getPort();
            }
            adminPortString = "" + adminPort;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.info(strings.get("ServerStart.SuccessMessage", new Object[]{this.info.isDomain() ? "domain " : "instance", this.serverDirs.getServerName(), this.serverDirs.getServerDir(), logfile, adminPortString}));
        if (this.debugPort >= 0) {
            this.logger.info(strings.get("ServerStart.DebuggerMessage", new Object[]{"" + this.debugPort}));
        }
    }

    private void waitForParentToDie() throws CommandException {
        String pids = System.getProperty("AS_RESTART");
        if (!StringUtils.ok((String)pids)) {
            return;
        }
        int pid = -1;
        try {
            pid = Integer.parseInt(pids);
        }
        catch (Exception e) {
            pid = -1;
        }
        this.waitForParentDeath(pid);
    }

    private boolean checkPorts() {
        String err = this.adminPortInUse();
        if (err != null) {
            this.logger.warning(err);
            return false;
        }
        return true;
    }

    private void deletePidFile() {
        String msg = this.serverDirs.deletePidFile();
        if (msg != null && this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(msg);
        }
    }

    private void setSecurity() {
        this.info.addSecurityToken("AS_ADMIN_MASTERPASSWORD", this.masterPassword);
    }

    private String adminPortInUse() {
        return this.adminPortInUse(this.info.getAdminAddresses());
    }

    private String adminPortInUse(List<HostAndPort> adminAddresses) {
        for (HostAndPort addr : adminAddresses) {
            if (NetUtils.isPortFree((String)addr.getHost(), (int)addr.getPort())) continue;
            return strings.get("ServerRunning", new Object[]{Integer.toString(addr.getPort())});
        }
        return null;
    }

    private void waitForParentDeath(int pid) throws CommandException {
        if (pid < 0) {
            new ParentDeathWaiterPureJava();
            return;
        }
        long start = System.currentTimeMillis();
        try {
            do {
                Boolean b;
                if ((b = ProcessUtils.isProcessRunning((int)pid)) == null) {
                    StartServerHelper.debugMessage("ProcessUtils.isProcessRunning(" + pid + ") returned null which means we can't get process info on this platform.");
                    new ParentDeathWaiterPureJava();
                    return;
                }
                if (!b.booleanValue()) {
                    StartServerHelper.debugMessage("Parent process (" + pid + ") is dead.");
                    return;
                }
                StartServerHelper.debugMessage("Wait one more second for parent to die...");
                Thread.sleep(1000L);
            } while (!StartServerHelper.timedOut(start, 60000L));
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new CommandException(strings.get("deathwait_timeout", new Object[]{60000L}));
    }

    private static boolean timedOut(long startTime) {
        return StartServerHelper.timedOut(startTime, 600000L);
    }

    private static boolean timedOut(long startTime, long span) {
        return System.currentTimeMillis() - startTime > span;
    }

    private static void debugMessage(String s) {
    }

    private class ParentDeathWaiterPureJava
    implements Runnable {
        boolean success = false;

        @Override
        public void run() {
            try {
                while (System.in.read() >= 0) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            while (StartServerHelper.this.adminPortInUse(StartServerHelper.this.addresses) != null) {
            }
            this.success = true;
        }

        private ParentDeathWaiterPureJava() throws CommandException {
            try {
                Thread deathWaiterThread = new Thread(this);
                deathWaiterThread.start();
                deathWaiterThread.join(60000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.success) {
                throw new CommandException(strings.get("deathwait_timeout", new Object[]{60000L}));
            }
        }
    }
}

