/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ha.store.adapter.cache;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.api.BackingStoreTransaction;
import org.glassfish.ha.store.spi.BackingStoreFactoryRegistry;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="replicated")
@RunLevel(value=10)
public class ShoalBackingStoreProxy
implements PostConstruct,
BackingStoreFactory {
    @Inject
    ServiceLocator habitat;
    @Inject
    Events events;

    @Override
    public <K extends Serializable, V extends Serializable> BackingStore<K, V> createBackingStore(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        try {
            BackingStoreFactory storeFactory = (BackingStoreFactory)this.habitat.getService(BackingStoreFactory.class, "shoal-backing-store-factory", new Annotation[0]);
            return storeFactory.createBackingStore(conf);
        }
        catch (IllegalStateException ex) {
            String msg = "ReplicatedBackingStore requires GMS to be running in the target cluster before the application is deployed. ";
            throw new BackingStoreException("Exception while creating replicated BackingStore. " + msg, ex);
        }
        catch (Exception ex) {
            throw new BackingStoreException("Exception while creating shoal cache", ex);
        }
    }

    public void postConstruct() {
        BackingStoreFactoryRegistry.register("replicated", this);
        Logger.getLogger(ShoalBackingStoreProxy.class.getName()).log(Level.FINE, "Registered SHOAL BackingStore Proxy with persistence-type = replicated");
        EventListener glassfishEventListener = new EventListener(){

            public void event(EventListener.Event event) {
                if (event.is(EventTypes.SERVER_SHUTDOWN)) {
                    BackingStoreFactoryRegistry.unregister("replicated");
                    Logger.getLogger(ShoalBackingStoreProxy.class.getName()).log(Level.FINE, "Unregistered SHOAL BackingStore Proxy with persistence-type = replicated");
                }
            }
        };
        this.events.register(glassfishEventListener);
    }

    @Override
    public BackingStoreTransaction createBackingStoreTransaction() {
        try {
            BackingStoreFactory storeFactory = (BackingStoreFactory)this.habitat.getService(BackingStoreFactory.class, "shoal-backing-store-factory", new Annotation[0]);
            return storeFactory.createBackingStoreTransaction();
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while creating shoal cache", ex);
        }
    }
}

