/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.Jps;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.Strings;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.List;

public final class ProcessUtils {
    static final File jpsExe;
    static final String jpsName;
    static final File jstackExe;
    static final String jstackName;
    private static final int pid;
    private static final String[] paths;
    private static boolean debug;

    private ProcessUtils() {
    }

    public static void main(String[] args) {
        debug = true;
        for (String s : args) {
            String ret = ProcessUtils.killJvm(s);
            if (ret == null) {
                ret = "SUCCESS!!";
            }
            System.out.println(s + " ===> " + ret);
        }
    }

    public static File getExe(String name) {
        for (String path : paths) {
            File f = new File(path + "/" + name);
            if (!f.canExecute()) continue;
            return SmartFile.sanitize(f);
        }
        return null;
    }

    public static int getPid() {
        return pid;
    }

    public static String kill(int pid) {
        try {
            String cmdline;
            String pidString = Integer.toString(pid);
            ProcessManager pm = null;
            if (OS.isWindowsForSure()) {
                pm = new ProcessManager("taskkill", "/F", "/T", "/pid", pidString);
                cmdline = "taskkill /F /T /pid " + pidString;
            } else {
                pm = new ProcessManager("kill", "-9", pidString);
                cmdline = "kill -9 " + pidString;
            }
            pm.setEcho(false);
            pm.execute();
            int exitValue = pm.getExitValue();
            if (exitValue == 0) {
                return null;
            }
            return Strings.get("ProcessUtils.killerror", cmdline, pm.getStderr() + pm.getStdout(), "" + exitValue);
        }
        catch (ProcessManagerException ex) {
            return ex.getMessage();
        }
    }

    public static String killJvm(String classname) {
        List<Integer> pids = Jps.getPid(classname);
        StringBuilder sb = new StringBuilder();
        int numDead = 0;
        for (int p : pids) {
            String s = ProcessUtils.kill(p);
            if (s != null) {
                sb.append(s).append('\n');
                continue;
            }
            ++numDead;
        }
        String err = sb.toString();
        if (err.length() > 0 || numDead <= 0) {
            return Strings.get("ProcessUtils.killjvmerror", err, numDead);
        }
        return null;
    }

    public static Boolean isProcessRunning(int aPid) {
        try {
            if (OS.isWindowsForSure()) {
                return ProcessUtils.isProcessRunningWindows(aPid);
            }
            return ProcessUtils.isProcessRunningUnix(aPid);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isProcessRunningWindows(int aPid) throws ProcessManagerException {
        String pidString = Integer.toString(aPid);
        ProcessManager pm = new ProcessManager("tasklist", "/NH", "/FI", "\"pid eq " + pidString + "\"");
        pm.setEcho(false);
        pm.execute();
        String out = pm.getStdout() + pm.getStderr();
        if (debug) {
            System.out.println("------------   Output from tasklist   ----------");
            System.out.println(out);
            System.out.println("------------------------------------------------");
        }
        if (StringUtils.ok(out)) {
            return out.indexOf("java.exe") >= 0 && out.indexOf(pidString) >= 0;
        }
        throw new ProcessManagerException("unknown");
    }

    private static Boolean isProcessRunningUnix(int aPid) throws ProcessManagerException {
        ProcessManager pm = new ProcessManager("kill", "-0", "" + aPid);
        pm.setEcho(false);
        pm.execute();
        int retval = pm.getExitValue();
        return retval == 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    static {
        int tempPid = -1;
        try {
            String pids = ManagementFactory.getRuntimeMXBean().getName();
            int index = -1;
            if (StringUtils.ok(pids) && (index = pids.indexOf(64)) >= 0) {
                tempPid = Integer.parseInt(pids.substring(0, index));
            }
        }
        catch (Exception e) {
            tempPid = -1;
        }
        pid = tempPid;
        String tempPaths = null;
        if (OS.isWindows()) {
            tempPaths = System.getenv("Path");
            if (!StringUtils.ok(tempPaths)) {
                tempPaths = System.getenv("PATH");
            }
        } else {
            tempPaths = System.getenv("PATH");
        }
        paths = StringUtils.ok(tempPaths) ? tempPaths.split(File.pathSeparator) : new String[0];
        if (OS.isWindows()) {
            jpsName = "jps.exe";
            jstackName = "jstack.exe";
        } else {
            jpsName = "jps";
            jstackName = "jstack";
        }
        String javaroot = System.getProperty("java.home");
        String relpath = "/bin";
        File fhere1 = new File(javaroot + "/bin/" + jpsName);
        File fhere2 = new File(javaroot + "/bin/" + jstackName);
        File fthere1 = new File(javaroot + "/../bin/" + jpsName);
        File fthere2 = new File(javaroot + "/../bin/" + jstackName);
        jpsExe = fhere1.isFile() ? SmartFile.sanitize(fhere1) : (fthere1.isFile() ? SmartFile.sanitize(fthere1) : null);
        jstackExe = fhere2.isFile() ? SmartFile.sanitize(fhere2) : (fthere2.isFile() ? SmartFile.sanitize(fthere2) : null);
    }
}

