/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.GlassFishImpl;
import com.sun.enterprise.glassfish.bootstrap.MainHelper;
import com.sun.enterprise.glassfish.bootstrap.osgi.EmbeddedOSGiGlassFishImpl;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.FelixPrettyPrinter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class EmbeddedOSGiGlassFishRuntime
extends GlassFishRuntime {
    List<GlassFish> gfs = new ArrayList<GlassFish>();
    private final BundleContext context;

    public EmbeddedOSGiGlassFishRuntime(BundleContext context) {
        this.context = context;
    }

    @Override
    public synchronized GlassFish newGlassFish(GlassFishProperties gfProps) throws GlassFishException {
        try {
            this.setEnv(gfProps.getProperties());
            StartupContext startupContext = new StartupContext(gfProps.getProperties());
            ServiceTracker hk2Tracker = new ServiceTracker(this.getBundleContext(), Main.class.getName(), null);
            hk2Tracker.open();
            Main main = (Main)hk2Tracker.waitForService(0L);
            hk2Tracker.close();
            ModulesRegistry mr = (ModulesRegistry)ModulesRegistry.class.cast(this.getBundleContext().getService(this.getBundleContext().getServiceReference(ModulesRegistry.class.getName())));
            ServiceLocator serviceLocator = main.createServiceLocator(mr, startupContext, null, null);
            ModuleStartup gfKernel = main.findStartupService(mr, serviceLocator, null, startupContext);
            GlassFish glassFish = this.createGlassFish(gfKernel, serviceLocator, gfProps.getProperties());
            this.gfs.add(glassFish);
            return glassFish;
        }
        catch (BootException | InterruptedException ex) {
            throw new GlassFishException((Throwable)ex);
        }
        catch (MultiException ex) {
            GlassFishException e = null;
            String bundleMessage = "";
            try {
                bundleMessage = this.findBundleMessage(ex);
                if (bundleMessage != null) {
                    List bundleIDs = FelixPrettyPrinter.findBundleIds((String)(bundleMessage = FelixPrettyPrinter.prettyPrintExceptionMessage((String)bundleMessage)));
                    if (!bundleIDs.isEmpty()) {
                        StringBuilder bundleBuilder = new StringBuilder(bundleMessage);
                        for (Integer bundleId : bundleIDs) {
                            Bundle bundle = this.context.getBundle((long)bundleId.intValue());
                            if (bundle == null) continue;
                            bundleBuilder.append("[" + bundleId + "] \n").append("jar = " + bundle.getLocation());
                            this.tryAddPomProperties(bundle, bundleBuilder);
                            bundleBuilder.append("\n");
                        }
                        bundleMessage = bundleBuilder.toString();
                    }
                    e = new GlassFishException("\n\n" + bundleMessage, ex);
                }
            }
            catch (Exception ee) {
                e = new GlassFishException("\n\n" + bundleMessage, ex);
                e.addSuppressed(ee);
            }
            if (e == null) {
                throw ex;
            }
            throw e;
        }
    }

    private void tryAddPomProperties(Bundle bundle, StringBuilder bundleBuilder) throws IOException {
        Enumeration entries = bundle.findEntries("META-INF/maven/", "pom.properties", true);
        while (entries.hasMoreElements()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(((URL)entries.nextElement()).openStream(), StandardCharsets.UTF_8));){
                reader.lines().filter(e -> !e.startsWith("#")).forEach(e -> bundleBuilder.append("\n" + e.replace("=", " = ")));
            }
            bundleBuilder.append("\n");
        }
    }

    private String findBundleMessage(MultiException ex) {
        Iterator iterator = ex.getErrors().iterator();
        while (iterator.hasNext()) {
            Throwable error;
            for (Throwable currentThrowable = error = (Throwable)iterator.next(); currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
                if (!(currentThrowable instanceof BundleException)) continue;
                return currentThrowable.getMessage();
            }
        }
        return null;
    }

    @Override
    public synchronized void shutdown() throws GlassFishException {
        for (GlassFish gf : new ArrayList<GlassFish>(this.gfs)) {
            if (gf.getStatus() == GlassFish.Status.DISPOSED) continue;
            try {
                gf.dispose();
            }
            catch (GlassFishException e) {
                e.printStackTrace();
            }
        }
        this.gfs.clear();
        EmbeddedOSGiGlassFishRuntime.shutdownInternal();
        System.out.println("Completed shutdown of GlassFish runtime");
    }

    private void setEnv(Properties properties) {
        String instanceRootValue;
        String installRootValue = properties.getProperty("com.sun.aas.installRoot");
        if (installRootValue != null && !installRootValue.isEmpty()) {
            File installRoot = new File(installRootValue);
            System.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
            Properties asenv = MainHelper.parseAsEnv(installRoot);
            for (String s : asenv.stringPropertyNames()) {
                System.setProperty(s, asenv.getProperty(s));
            }
            System.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        }
        if ((instanceRootValue = properties.getProperty("com.sun.aas.instanceRoot")) != null && !instanceRootValue.isEmpty()) {
            File instanceRoot = new File(instanceRootValue);
            System.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
            System.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        }
    }

    protected GlassFish createGlassFish(ModuleStartup gfKernel, ServiceLocator habitat, Properties gfProps) throws GlassFishException {
        GlassFishImpl gf = new GlassFishImpl(gfKernel, habitat, gfProps);
        return new EmbeddedOSGiGlassFishImpl(gf, this.getBundleContext());
    }

    private BundleContext getBundleContext() {
        return this.context;
    }
}

