/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.constraints.transformer;

import jakarta.servlet.annotation.ServletSecurity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConstraintValue {
    private static final System.Logger LOG = System.getLogger(ConstraintValue.class.getName());
    public static final String[] connectKeys = new String[]{"NONE", "INTEGRAL", "CONFIDENTIAL"};
    public static final int connectTypeNone = 1;
    static Map<String, Integer> connectHash = new HashMap<String, Integer>();
    private boolean excluded;
    private boolean ignoreRoles;
    private final List<String> roles = new ArrayList<String>();
    private int connectSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRole(String role) {
        List<String> list = this.roles;
        synchronized (list) {
            if (!this.roles.contains(role)) {
                this.roles.add(role);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRole(String role) {
        List<String> list = this.roles;
        synchronized (list) {
            if (this.roles.contains(role)) {
                this.roles.remove(role);
            }
        }
    }

    public List<String> getRoles() {
        return this.roles;
    }

    boolean isExcluded() {
        return this.excluded;
    }

    boolean isUncovered() {
        if (this.excluded) {
            return false;
        }
        return !this.ignoreRoles && this.roles.isEmpty() && this.connectSet == 0;
    }

    boolean isAuthConstrained() {
        if (this.excluded) {
            return true;
        }
        return !this.ignoreRoles && !this.roles.isEmpty();
    }

    void addConnectType(ServletSecurity.TransportGuarantee guarantee) {
        int b = 1;
        if (guarantee != null) {
            Integer bit = connectHash.get(guarantee.name());
            if (bit == null) {
                throw new IllegalArgumentException("constraint translation error-illegal trx guarantee");
            }
            b = bit;
        }
        this.connectSet |= b;
    }

    boolean isConnectAllowed(int connectType) {
        if (this.excluded) {
            return false;
        }
        return this.connectSet == 0 || this.containsConnectType(1) || this.containsConnectType(connectType);
    }

    private boolean containsConnectType(int connectType) {
        return ConstraintValue.bitIsSet(this.connectSet, connectType);
    }

    private static boolean bitIsSet(int map, int bit) {
        return (map & bit) == bit;
    }

    void setOutcome(Set<String> declaredRoles, Set<String> constraintRolesAllowed, ServletSecurity.TransportGuarantee transportGuarantee) {
        if (constraintRolesAllowed == null) {
            this.setPredefinedOutcome(true);
        } else if (constraintRolesAllowed.isEmpty()) {
            this.setPredefinedOutcome(false);
        } else {
            boolean containsAllRoles = false;
            for (String roleName : constraintRolesAllowed) {
                if ("*".equals(roleName)) {
                    containsAllRoles = true;
                    continue;
                }
                this.setRole(roleName);
            }
            if (containsAllRoles) {
                this.removeRole("**");
                for (String role : declaredRoles) {
                    this.setRole(role);
                }
            }
        }
        this.addConnectType(transportGuarantee);
        LOG.log(System.Logger.Level.DEBUG, "setOutcome yields: {0}", this);
    }

    void setPredefinedOutcome(boolean outcome) {
        if (!outcome) {
            this.excluded = true;
        } else {
            this.ignoreRoles = true;
        }
    }

    void setValue(ConstraintValue constraint) {
        this.excluded = constraint.excluded;
        this.ignoreRoles = constraint.ignoreRoles;
        this.roles.clear();
        this.roles.addAll(constraint.roles);
        this.connectSet = constraint.connectSet;
    }

    public String toString() {
        StringBuilder rolesBuilder = new StringBuilder(" roles: ");
        for (String role : this.roles) {
            rolesBuilder.append(" ").append(role);
        }
        StringBuilder transportsBuilder = new StringBuilder("transports: ");
        for (int i = 0; i < connectKeys.length; ++i) {
            if (!this.isConnectAllowed(1 << i)) continue;
            transportsBuilder.append(" ").append(connectKeys[i]);
        }
        return " ConstraintValue (  excluded: " + this.excluded + " ignoreRoleList: " + this.ignoreRoles + rolesBuilder + transportsBuilder + " ) ";
    }

    static {
        for (int i = 0; i < connectKeys.length; ++i) {
            connectHash.put(connectKeys[i], 1 << i);
        }
    }
}

