/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.modules.def;

import jakarta.security.jacc.PolicyContextException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.exousia.modules.def.DefaultPolicyConfigurationBase;

public abstract class DefaultPolicyConfigurationPermissions
extends DefaultPolicyConfigurationBase {
    private Permissions excludedPermissions = new Permissions();
    private Permissions uncheckedPermissions = new Permissions();
    private Map<String, PermissionCollection> perRolePermissions = new HashMap<String, PermissionCollection>();

    public DefaultPolicyConfigurationPermissions(String contextID) {
        super(contextID);
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        this.excludedPermissions.add(permission);
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        this.uncheckedPermissions.add(permission);
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        PermissionCollection permissions = this.perRolePermissions.get(roleName);
        if (permissions == null) {
            permissions = new Permissions();
            this.perRolePermissions.put(roleName, permissions);
        }
        permissions.add(permission);
    }

    public void delete() throws PolicyContextException {
        this.removeExcludedPolicy();
        this.removeUncheckedPolicy();
        this.perRolePermissions.clear();
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        this.excludedPermissions = new Permissions();
    }

    public void removeRole(String roleName) throws PolicyContextException {
        if (this.perRolePermissions.containsKey(roleName)) {
            this.perRolePermissions.remove(roleName);
        } else if ("*".equals(roleName)) {
            this.perRolePermissions.clear();
        }
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        this.uncheckedPermissions = new Permissions();
    }

    public PermissionCollection getExcludedPermissions() {
        return this.excludedPermissions;
    }

    public PermissionCollection getUncheckedPermissions() {
        return this.uncheckedPermissions;
    }

    public Map<String, PermissionCollection> getPerRolePermissions() {
        return this.perRolePermissions;
    }
}

