/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beansdev.DocDefHandler;
import org.netbeans.modules.schema2beansdev.EntityParser;
import org.netbeans.modules.schema2beansdev.GenBeans;
import org.netbeans.modules.schema2beansdev.GeneralParser;
import org.netbeans.modules.schema2beansdev.SchemaParseException;
import org.netbeans.modules.schema2beansdev.SchemaParser;

public class DocDefParser
extends GeneralParser
implements SchemaParser {
    private static final int WORD_NO_CONTEXT = 0;
    private static final int WORD_CHECK = 1;
    private static final int WORD_COMMENT = 2;
    private static final int WORD_ELEMENT1 = 3;
    private static final int WORD_ELEMENT = 4;
    private static final int WORD_ATTLIST1 = 5;
    private static final int WORD_ATTLIST = 6;
    private static final int WORD_PI = 7;
    private static final int WORD_ENTITY1 = 10;
    private static final int WORD_ENTITY = 11;
    static String errHeader = "DTD parsing failed: ";
    private char[] buffer = new char[BUFFER_SIZE];
    private int bufSize;
    private int bufScan;
    protected static int BUFFER_SIZE = 4096;
    private DocDefHandler handler;
    private GenBeans.Config config = null;

    public DocDefParser() {
    }

    public DocDefParser(GenBeans.Config config, DocDefHandler handler) {
        this.config = config;
        this.filename = config.getFilename();
        this.schemaIn = config.getFileIn();
        this.handler = handler;
    }

    @Override
    protected void startupReader() throws IOException {
        if (this.schemaIn == null) {
            this.schemaIn = new FileInputStream(this.filename);
        }
        EntityParser entityParser = new EntityParser(new InputStreamReader(this.schemaIn));
        entityParser.parse();
        this.reader = entityParser.getReader();
    }

    public void setHandler(DocDefHandler handler) {
        this.handler = handler;
    }

    public DocDefHandler getHandler() {
        return this.handler;
    }

    protected boolean checkBuffer() throws IOException {
        if (this.bufScan >= this.bufSize) {
            this.bufSize = this.reader.read(this.buffer);
            if (this.bufSize == -1) {
                return false;
            }
            this.bufScan = 0;
        }
        return true;
    }

    protected char getNext() throws IOException {
        if (this.checkBuffer()) {
            return this.buffer[this.bufScan++];
        }
        return '\u0000';
    }

    protected char peekNext() throws IOException {
        if (this.checkBuffer()) {
            return this.buffer[this.bufScan];
        }
        return '\u0000';
    }

    private static int getInstanceValue(char c) {
        switch (c) {
            case '*': {
                return 48;
            }
            case '+': {
                return 64;
            }
            case '?': {
                return 16;
            }
        }
        return 32;
    }

    private int processWord(StringBuffer curWord, int wordContext) throws SchemaParseException {
        String word = curWord.toString();
        int len = word.length();
        if (len > 0) {
            switch (wordContext) {
                case 1: {
                    if (word.startsWith("--")) {
                        word = len > 2 ? curWord.substring(2) : "";
                        this.handler.startElement(word, word, 1);
                        wordContext = 2;
                        break;
                    }
                    if (word.equals("ELEMENT")) {
                        wordContext = 3;
                        break;
                    }
                    if (word.equals("ATTLIST")) {
                        wordContext = 5;
                        break;
                    }
                    if (word.equals("ENTITY")) {
                        wordContext = 10;
                        break;
                    }
                    throw new SchemaParseException("Error: found an unknown '<!' sequence (" + word + ")");
                }
                case 2: {
                    this.handler.element(word, word, 0);
                    break;
                }
                case 3: {
                    this.handler.startElement(word, word, 2);
                    wordContext = 4;
                    break;
                }
                case 5: {
                    this.handler.startElement(word, word, 3);
                    wordContext = 6;
                    break;
                }
                case 10: {
                    wordContext = 11;
                    break;
                }
                case 11: {
                    break;
                }
                case 4: 
                case 6: {
                    int instance = DocDefParser.getInstanceValue(word.charAt(len - 1));
                    if (instance != 32) {
                        word = curWord.substring(0, len - 1);
                    }
                    try {
                        this.handler.element(word, word, instance);
                    }
                    catch (MissingEndOfEltException e) {
                        if (wordContext != 6) break;
                        this.handler.startElement(e.propName, e.propName, 3);
                        this.handler.element(word, word, instance);
                    }
                    break;
                }
            }
            curWord.delete(0, len);
        }
        return wordContext;
    }

    void parse() throws IOException, SchemaParseException {
        char c;
        StringBuffer curWord = new StringBuffer();
        int wordContext = 0;
        boolean level = false;
        block14: while ((c = this.getNext()) != '\u0000') {
            block0 : switch (c) {
                case '<': {
                    char c1 = this.getNext();
                    if (c1 == '!') {
                        if (wordContext != 0 && wordContext != 2) {
                            System.err.println("Error: found a '<!' sequence within another '<!' sequence");
                            throw new SchemaParseException("Warning: found a '<!' sequence within another '<!' sequence");
                        }
                        if (wordContext == 2) continue block14;
                        wordContext = 1;
                        break;
                    }
                    if (c1 == '?') {
                        wordContext = 7;
                        break;
                    }
                    curWord.append(c);
                    curWord.append(c1);
                    break;
                }
                case '>': {
                    switch (wordContext) {
                        case 0: {
                            throw new SchemaParseException("Error: Found '>' without '<!'");
                        }
                        case 7: {
                            String word = curWord.toString();
                            int len = word.length();
                            if (word.endsWith("?")) {
                                curWord.delete(0, len);
                                wordContext = 0;
                                break block0;
                            }
                            curWord.append(c);
                            break block0;
                        }
                        case 2: {
                            String word = curWord.toString();
                            int len = word.length();
                            if (word.endsWith("--")) {
                                this.handler.endElement();
                                curWord.delete(0, len);
                                wordContext = 0;
                                break block0;
                            }
                            curWord.append(c);
                            break block0;
                        }
                        case 11: {
                            wordContext = 0;
                            break block0;
                        }
                    }
                    wordContext = this.processWord(curWord, wordContext);
                    this.handler.endElement();
                    wordContext = 0;
                    break;
                }
                case '(': {
                    if (wordContext == 4 || wordContext == 6) {
                        wordContext = this.processWord(curWord, wordContext);
                        this.handler.startGroupElements();
                        break;
                    }
                    curWord.append(c);
                    break;
                }
                case ')': {
                    wordContext = this.processWord(curWord, wordContext);
                    if (wordContext == 4 || wordContext == 6) {
                        int instance = DocDefParser.getInstanceValue(this.peekNext());
                        if (instance != 32) {
                            this.getNext();
                        }
                        this.handler.endGroupElements(instance);
                        break;
                    }
                    curWord.append(c);
                    break;
                }
                case '|': {
                    wordContext = this.processWord(curWord, wordContext);
                    if (wordContext == 4 || wordContext == 6) {
                        this.handler.character(c);
                        break;
                    }
                    curWord.append(c);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    wordContext = this.processWord(curWord, wordContext);
                    break;
                }
                default: {
                    curWord.append(c);
                }
            }
        }
        if (wordContext != 0) {
            System.out.println("Warning: unexpected EOF");
        }
    }

    @Override
    public void process() throws IOException, Schema2BeansException {
        if (this.filename == null && this.schemaIn == null) {
            throw new IllegalArgumentException(Common.getMessage("FilenameNotSpecified_msg", errHeader));
        }
        if (this.handler == null) {
            throw new IllegalArgumentException(Common.getMessage("HandlerNotSpecified_msg", errHeader));
        }
        if (this.config.isTraceParse()) {
            this.config.messageOut.println("Parsing file " + this.filename.toString() + " with handler " + this.handler.getClass());
        }
        try {
            this.startupReader();
            this.handler.startDocument(this.config.getDocRoot());
            this.parse();
            this.shutdownReader();
            this.handler.endDocument();
        }
        catch (FileNotFoundException e) {
            this.config.messageOut.println("Error: file " + this.filename.toString() + " not found");
            throw e;
        }
    }

    static class MissingEndOfEltException
    extends RuntimeException {
        String propName;

        public MissingEndOfEltException(String propName) {
            this.propName = propName;
        }
    }
}

