/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import java.util.Vector;
import org.glassfish.rmic.iiop.BatchEnvironment;
import org.glassfish.rmic.iiop.CompoundType;
import org.glassfish.rmic.iiop.ContextStack;
import org.glassfish.rmic.iiop.InterfaceType;
import org.glassfish.rmic.iiop.Type;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.CompilerError;

public class RemoteType
extends InterfaceType {
    public static RemoteType forRemote(ClassDefinition classDef, ContextStack stack, boolean quiet) {
        RemoteType result;
        block8: {
            if (stack.anyErrors()) {
                return null;
            }
            boolean doPop = false;
            result = null;
            try {
                org.glassfish.rmic.tools.java.Type theType = classDef.getType();
                Type existing = RemoteType.getType(theType, stack);
                if (existing != null) {
                    if (!(existing instanceof RemoteType)) {
                        return null;
                    }
                    return (RemoteType)existing;
                }
                if (RemoteType.couldBeRemote(quiet, stack, classDef)) {
                    RemoteType it = new RemoteType(stack, classDef);
                    RemoteType.putType(theType, (Type)it, stack);
                    stack.push(it);
                    doPop = true;
                    if (it.initialize(quiet, stack)) {
                        stack.pop(true);
                        result = it;
                    } else {
                        RemoteType.removeType(theType, stack);
                        stack.pop(false);
                    }
                }
            }
            catch (CompilerError e) {
                if (!doPop) break block8;
                stack.pop(false);
            }
        }
        return result;
    }

    @Override
    public String getTypeDescription() {
        return "Remote interface";
    }

    protected RemoteType(ContextStack stack, ClassDefinition classDef) {
        super(stack, classDef, 0xA001000);
    }

    protected RemoteType(ContextStack stack, ClassDefinition classDef, int typeCode) {
        super(stack, classDef, typeCode);
    }

    private static boolean couldBeRemote(boolean quiet, ContextStack stack, ClassDefinition classDef) {
        boolean result = false;
        BatchEnvironment env = stack.getEnv();
        try {
            if (!classDef.isInterface()) {
                RemoteType.failedConstraint(16, quiet, stack, classDef.getName());
            } else {
                result = env.defRemote.implementedBy(env, classDef.getClassDeclaration());
                if (!result) {
                    RemoteType.failedConstraint(1, quiet, stack, classDef.getName());
                }
            }
        }
        catch (ClassNotFound e) {
            RemoteType.classNotFound(stack, e);
        }
        return result;
    }

    private boolean initialize(boolean quiet, ContextStack stack) {
        boolean result = false;
        Vector<InterfaceType> directInterfaces = new Vector<InterfaceType>();
        Vector<CompoundType.Method> directMethods = new Vector<CompoundType.Method>();
        Vector<CompoundType.Member> directConstants = new Vector<CompoundType.Member>();
        if (this.isConformingRemoteInterface(directInterfaces, directMethods, directConstants, quiet, stack)) {
            result = this.initialize(directInterfaces, directMethods, directConstants, stack, quiet);
        }
        return result;
    }

    private boolean isConformingRemoteInterface(Vector<InterfaceType> directInterfaces, Vector<CompoundType.Method> directMethods, Vector<CompoundType.Member> directConstants, boolean quiet, ContextStack stack) {
        ClassDefinition theInterface = this.getClassDefinition();
        try {
            if (this.addRemoteInterfaces(directInterfaces, false, stack) == null) {
                return false;
            }
            if (!this.addAllMembers(directConstants, true, quiet, stack)) {
                return false;
            }
            if (this.addAllMethods(theInterface, directMethods, true, quiet, stack) == null) {
                return false;
            }
            boolean methodsConform = true;
            for (int i = 0; i < directMethods.size(); ++i) {
                if (this.isConformingRemoteMethod(directMethods.elementAt(i), quiet)) continue;
                methodsConform = false;
            }
            if (!methodsConform) {
                return false;
            }
        }
        catch (ClassNotFound e) {
            RemoteType.classNotFound(stack, e);
            return false;
        }
        return true;
    }
}

